/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.PatcherException;
import com.prupe.mcpatcher.ProfileManager;
import com.prupe.mcpatcher.Util;
import com.prupe.mcpatcher.launcher.profile.Profile;
import com.prupe.mcpatcher.launcher.version.Library;
import com.prupe.mcpatcher.launcher.version.Version;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import javassist.bytecode.ClassFile;

class MinecraftJar {
    private final ProfileManager profileManager;
    private final File inputFile;
    private final File outputFile;
    private final String inputMD5;
    private final String origMD5;
    private final MinecraftVersion inputVersion;
    private final Map<String, ClassFile> classes = new HashMap<String, ClassFile>();
    private JarFile inputJar;
    private JarOutputStream outputJar;

    MinecraftJar(ProfileManager profileManager) throws PatcherException {
        this.profileManager = profileManager;
        this.inputFile = profileManager.getInputJar();
        this.outputFile = profileManager.getOutputJar();
        this.inputMD5 = Util.computeMD5(this.inputFile);
        this.inputVersion = MinecraftVersion.parseVersion(profileManager.getInputBaseVersion());
        if (this.inputVersion == null) {
            throw new PatcherException.CorruptJarFile(this.inputFile);
        }
        this.origMD5 = MinecraftVersion.getOriginalMD5(this.inputVersion);
    }

    static boolean isGarbageFile(String filename) {
        return filename.startsWith("META-INF") || filename.startsWith("__MACOSX") || filename.endsWith(".DS_Store") || filename.equals("mod.properties");
    }

    static boolean isClassFile(String filename) {
        return filename.endsWith(".class") && !MinecraftJar.isGarbageFile(filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setDefaultTexturePack() {
        File output;
        File input;
        block10: {
            input = MCPatcherUtils.getMinecraftPath("options.txt");
            if (!input.exists()) {
                return;
            }
            output = MCPatcherUtils.getMinecraftPath("options.txt.tmp");
            BufferedReader reader = null;
            PrintWriter writer = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(input));
                writer = new PrintWriter(new FileWriter(output));
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("skin:")) {
                        line = "skin:Default";
                    }
                    writer.println(line);
                }
                MCPatcherUtils.close(reader);
            }
            catch (IOException e) {
                Logger.log(e);
                break block10;
            }
            finally {
                MCPatcherUtils.close(reader);
                MCPatcherUtils.close(writer);
            }
            MCPatcherUtils.close(writer);
        }
        try {
            Util.copyFile(output, input);
            output.delete();
        }
        catch (IOException e) {
            Logger.log(e);
        }
    }

    protected void finalize() throws Throwable {
        this.closeStreams();
        super.finalize();
    }

    MinecraftVersion getVersion() {
        return this.inputVersion;
    }

    boolean isModded() {
        return !MinecraftVersion.isKnownMD5(this.inputMD5) && this.origMD5 != null && !this.origMD5.equals(this.inputMD5);
    }

    void logVersion() {
        Logger.log(0, "Minecraft version is %s (md5 %s)", this.inputVersion, this.inputMD5);
        if (this.inputVersion.isNewerThanAnyKnownVersion()) {
            Logger.log(0, "WARNING: version is newer than any known version", new Object[0]);
        } else if (this.origMD5 == null) {
            Logger.log(0, "WARNING: could not determine original md5 sum", new Object[0]);
        } else if (this.isModded()) {
            Logger.log(0, "WARNING: possibly modded minecraft.jar (orig md5 %s)", this.origMD5);
        }
    }

    JarFile getInputJar() throws IOException {
        if (this.inputJar == null) {
            this.inputJar = new JarFile(this.inputFile, false);
        }
        return this.inputJar;
    }

    JarOutputStream getOutputJar() throws IOException {
        if (this.outputJar == null) {
            this.outputJar = new JarOutputStream(new FileOutputStream(this.outputFile));
        }
        return this.outputJar;
    }

    File getInputFile() {
        return this.inputFile;
    }

    File getOutputFile() {
        return this.outputFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClassFile getClassFile(ZipEntry entry) throws IOException {
        String name = entry.getName();
        ClassFile classFile = this.classes.get(name);
        if (classFile == null) {
            InputStream input = null;
            try {
                input = this.getInputJar().getInputStream(entry);
                classFile = new ClassFile(new DataInputStream(input));
                this.classes.put(name, classFile);
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(input);
                throw throwable;
            }
            MCPatcherUtils.close(input);
        }
        return classFile;
    }

    void writeProperties(Properties properties) throws IOException {
        block3: {
            if (this.origMD5 != null) {
                properties.setProperty("prePatchState", this.isModded() ? "modded" : "unmodded");
            }
            try {
                this.outputJar.putNextEntry(new ZipEntry("mcpatcher.properties"));
                properties.store(this.outputJar, null);
            }
            catch (IOException e) {
                if (e.toString().contains("duplicate entry")) break block3;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkOutput() throws Exception {
        this.closeStreams();
        JarFile jar = null;
        try {
            jar = new JarFile(this.outputFile);
        }
        catch (Throwable throwable) {
            MCPatcherUtils.close(jar);
            throw throwable;
        }
        MCPatcherUtils.close(jar);
    }

    void closeStreams() {
        MCPatcherUtils.close(this.inputJar);
        MCPatcherUtils.close(this.outputJar);
        this.inputJar = null;
        this.outputJar = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void run() throws PatcherException, IOException {
        File jarFile = this.getOutputFile();
        Profile profile = this.profileManager.getOutputProfileData();
        if (profile == null) {
            throw new IllegalStateException(String.format("Output profile '%s' unexpectedly missing", this.profileManager.getOutputProfile()));
        }
        Version version = this.profileManager.getOutputVersionData();
        if (version == null || !version.isComplete()) {
            throw new IllegalStateException(String.format("Output version '%s' unexpectedly missing", this.profileManager.getOutputVersion()));
        }
        ArrayList<String> cmdLine = new ArrayList<String>();
        HashMap<String, String> gameArgs = new HashMap<String, String>();
        File java = profile.getJavaExe();
        if (java != null && java.isFile()) {
            cmdLine.add(java.getAbsolutePath());
        } else {
            cmdLine.add("java");
        }
        if ("osx".equals(Library.getOSType())) {
            cmdLine.add("-Xdock:icon=" + MCPatcherUtils.getMinecraftPath("assets", "icons", "minecraft.icns").getPath());
            cmdLine.add("-Xdock:name=Minecraft");
        } else if ("windows".equals(Library.getOSType())) {
            cmdLine.add("-XX:HeapDumpPath=MojangTricksIntelDriversForPerformance_javaw.exe_minecraft.exe.heapdump");
        }
        if (!profile.getJavaArguments(cmdLine)) {
            String mem = "32".equals(System.getProperty("sun.arch.data.model")) ? "512M" : "1G";
            cmdLine.add("-Xmx" + mem);
        }
        profile.setGameArguments(gameArgs, this.profileManager.getProfileList());
        version.setGameArguments(gameArgs);
        File libDir = MCPatcherUtils.getMinecraftPath("libraries");
        File nativesDir = new File(jarFile.getParentFile(), this.profileManager.getOutputVersion() + "-natives-1");
        File oldNativesDir = new File(jarFile.getParentFile(), this.profileManager.getOutputVersion() + "-natives");
        if (oldNativesDir.isDirectory()) {
            File[] list = oldNativesDir.listFiles();
            if (list != null) {
                for (File f : list) {
                    f.delete();
                }
            }
            oldNativesDir.delete();
        }
        version.fetchLibraries(libDir);
        cmdLine.add("-cp");
        StringBuilder sb = new StringBuilder();
        ArrayList<File> classPath = new ArrayList<File>();
        version.addToClassPath(libDir, classPath);
        classPath.add(jarFile);
        for (File f : classPath) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparatorChar);
            }
            sb.append(f.getAbsolutePath());
        }
        cmdLine.add(sb.toString());
        version.unpackNatives(libDir, nativesDir);
        cmdLine.add("-Djava.library.path=" + nativesDir.getPath());
        cmdLine.add(version.getMainClass());
        profile.addGameArguments(gameArgs, cmdLine);
        version.addGameArguments(gameArgs, cmdLine);
        ProcessBuilder pb = new ProcessBuilder(cmdLine.toArray(new String[cmdLine.size()]));
        pb.redirectErrorStream(true);
        pb.directory(profile.getGameDir());
        File optionsTxt = MCPatcherUtils.getMinecraftPath("options.txt");
        File optionsTxtSaved = MCPatcherUtils.getMinecraftPath("options.save.txt");
        File optionsTxtVersion = MCPatcherUtils.getMinecraftPath("options." + this.getVersion().getVersionString() + ".txt");
        boolean copiedOptionsTxt = false;
        if (optionsTxt.isFile() && optionsTxtVersion.isFile()) {
            try {
                Util.copyFile(optionsTxt, optionsTxtSaved);
                Util.copyFile(optionsTxtVersion, optionsTxt);
                copiedOptionsTxt = true;
                Logger.log(0, "Using %s", optionsTxtVersion.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Logger.log(0);
        Logger.log(0, "Launching %s", jarFile.getPath());
        sb = new StringBuilder();
        for (String s : pb.command()) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            if (s.contains(" ")) {
                sb.append('\"');
                sb.append(s);
                sb.append('\"');
                continue;
            }
            sb.append(s);
        }
        Logger.log(0, "%s", sb.toString());
        Process p = pb.start();
        if (p != null) {
            String line;
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            Pattern stackDump = Pattern.compile("^\tat ([a-z]+)\\.\\w+\\(\\S+:\\d+\\)$");
            HashMap<String, String> reverseMap = MCPatcher.modList.getReverseMap();
            while ((line = input.readLine()) != null) {
                String obfName;
                String deobfName;
                MCPatcher.checkInterrupt();
                Matcher matcher = stackDump.matcher(line);
                if (matcher.find() && (deobfName = reverseMap.get(obfName = matcher.group(1))) != null && !deobfName.equals(obfName)) {
                    line = line + " [" + deobfName + "]";
                }
                Logger.log(0, "%s", line);
            }
            p.waitFor();
            if (p.exitValue() != 0) {
                Logger.log(0, "Minecraft exited with status %d", p.exitValue());
            }
        }
        if (!copiedOptionsTxt) return;
        try {
            Util.copyFile(optionsTxt, optionsTxtVersion);
            Util.copyFile(optionsTxtSaved, optionsTxt);
            optionsTxtSaved.delete();
            Logger.log(0, "Restoring %s", optionsTxt.getName());
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return;
        catch (InterruptedException e) {
            if (!copiedOptionsTxt) return;
            try {
                Util.copyFile(optionsTxt, optionsTxtVersion);
                Util.copyFile(optionsTxtSaved, optionsTxt);
                optionsTxtSaved.delete();
                Logger.log(0, "Restoring %s", optionsTxt.getName());
                return;
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            return;
        }
        catch (IOException e2) {
            Logger.log(e2);
            if (!copiedOptionsTxt) return;
            {
                catch (Throwable throwable) {
                    if (!copiedOptionsTxt) throw throwable;
                    try {
                        Util.copyFile(optionsTxt, optionsTxtVersion);
                        Util.copyFile(optionsTxtSaved, optionsTxt);
                        optionsTxtSaved.delete();
                        Logger.log(0, "Restoring %s", optionsTxt.getName());
                        throw throwable;
                    }
                    catch (IOException e3) {
                        e3.printStackTrace();
                    }
                    throw throwable;
                }
            }
            try {
                Util.copyFile(optionsTxt, optionsTxtVersion);
                Util.copyFile(optionsTxtSaved, optionsTxt);
                optionsTxtSaved.delete();
                Logger.log(0, "Restoring %s", optionsTxt.getName());
                return;
            }
            catch (IOException e4) {
                e4.printStackTrace();
            }
            return;
        }
    }
}

