/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.DeleteProfileDialog;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MainForm;
import com.prupe.mcpatcher.ModList;
import com.prupe.mcpatcher.ProfileManager;
import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.MenuElement;

class MainMenu {
    private final MainForm mainForm;
    final JMenuBar menuBar;
    private final JMenu file;
    private final JMenuItem refresh;
    private final JMenuItem exit;
    private final JMenu mods;
    private final JMenuItem addMod;
    private final JMenuItem removeMod;
    private final JMenuItem enableAll;
    private final JMenuItem disableAll;
    private final JMenuItem moveUp;
    private final JMenuItem moveDown;
    private final JMenu profile;
    private final JMenuItem select;
    private final JMenuItem delete;
    private final JMenu game;
    private final JMenuItem patch;
    private final JMenuItem unpatch;
    private final JMenuItem test;
    private final JMenu convert;
    JMenuItem convertItem;

    MainMenu(MainForm mainForm1) {
        this.mainForm = mainForm1;
        this.menuBar = new JMenuBar();
        this.file = new JMenu("File");
        this.file.setMnemonic('F');
        this.menuBar.add(this.file);
        this.refresh = new JMenuItem("Refresh version list");
        this.refresh.setMnemonic('R');
        this.refresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.mainForm.refreshMinecraft(true, true);
            }
        });
        this.file.add(this.refresh);
        this.file.addSeparator();
        this.exit = new JMenuItem("Exit");
        this.exit.setMnemonic('x');
        this.exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new WindowEvent(((MainMenu)MainMenu.this).mainForm.frame, 201));
            }
        });
        this.file.add(this.exit);
        this.mods = new JMenu("Mods");
        this.mods.setMnemonic('M');
        this.menuBar.add(this.mods);
        this.addMod = new JMenuItem("Add...");
        this.addMod.setMnemonic('A');
        MainMenu.copyActionListener(this.addMod, this.mainForm.addButton);
        this.mods.add(this.addMod);
        this.removeMod = new JMenuItem("Remove");
        this.removeMod.setMnemonic('R');
        MainMenu.copyActionListener(this.removeMod, this.mainForm.removeButton);
        this.mods.add(this.removeMod);
        this.mods.addSeparator();
        this.enableAll = new JMenuItem("Enable all");
        this.enableAll.setMnemonic('E');
        this.mods.add(this.enableAll);
        this.enableAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModList modList = MCPatcher.modList;
                if (modList != null) {
                    modList.enableValidMods(true);
                    MainMenu.this.mainForm.redrawModListCheckboxes();
                }
            }
        });
        this.disableAll = new JMenuItem("Disable all");
        this.disableAll.setMnemonic('D');
        this.mods.add(this.disableAll);
        this.disableAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModList modList = MCPatcher.modList;
                if (modList != null) {
                    modList.disableAll();
                    MainMenu.this.mainForm.redrawModListCheckboxes();
                }
            }
        });
        this.mods.addSeparator();
        this.moveUp = new JMenuItem("Move up");
        this.moveUp.setMnemonic('u');
        MainMenu.copyActionListener(this.moveUp, this.mainForm.upButton);
        this.mods.add(this.moveUp);
        this.moveDown = new JMenuItem("Move down");
        this.moveDown.setMnemonic('d');
        MainMenu.copyActionListener(this.moveDown, this.mainForm.downButton);
        this.mods.add(this.moveDown);
        this.mods.addSeparator();
        this.profile = new JMenu("Profile");
        this.profile.setMnemonic('r');
        this.menuBar.add(this.profile);
        this.select = new JMenu("Select input profile");
        this.select.setMnemonic('S');
        this.profile.add(this.select);
        this.delete = new JMenu("Delete output profile");
        this.delete.setMnemonic('D');
        this.profile.add(this.delete);
        this.game = new JMenu("Game");
        this.game.setMnemonic('G');
        this.menuBar.add(this.game);
        this.patch = new JMenuItem("Patch");
        this.patch.setMnemonic('P');
        MainMenu.copyActionListener(this.patch, this.mainForm.patchButton);
        this.game.add(this.patch);
        this.unpatch = new JMenuItem("Unpatch");
        this.unpatch.setMnemonic('U');
        MainMenu.copyActionListener(this.unpatch, this.mainForm.undoButton);
        this.game.add(this.unpatch);
        this.game.addSeparator();
        this.test = new JMenuItem("Test Minecraft");
        this.test.setMnemonic('T');
        MainMenu.copyActionListener(this.test, this.mainForm.testButton);
        this.game.add(this.test);
        this.convert = new JMenu("Convert Texture Pack");
        this.convert.setMnemonic('C');
        this.convert.setForeground(Color.RED);
        this.menuBar.add(this.convert);
        this.convertItem = new JMenuItem("Convert 1.4 to 1.5...");
        this.convertItem.setMnemonic('5');
        this.convertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.mainForm.showTexturePackConverter(15);
            }
        });
        this.convert.add(this.convertItem);
        this.convertItem = new JMenuItem("Convert 1.5 to 1.6...");
        this.convertItem.setMnemonic('6');
        this.convertItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainMenu.this.mainForm.showTexturePackConverter(16);
            }
        });
        this.convert.add(this.convertItem);
        this.updateControls(true);
    }

    private static void copyActionListener(JMenuItem item, final JButton button) {
        item.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (button.isEnabled()) {
                    for (ActionListener listener : button.getActionListeners()) {
                        listener.actionPerformed(e);
                    }
                }
            }
        });
    }

    void updateControls(boolean busy) {
        ArrayList<String> profiles;
        this.file.setEnabled(!busy);
        this.mods.setEnabled(!busy);
        this.profile.setEnabled(!busy);
        this.game.setEnabled(!busy);
        this.convert.setEnabled(!busy);
        this.addMod.setEnabled(this.mainForm.addButton.isEnabled());
        this.removeMod.setEnabled(this.mainForm.removeButton.isEnabled());
        this.moveUp.setEnabled(this.mainForm.upButton.isEnabled());
        this.moveDown.setEnabled(this.mainForm.downButton.isEnabled());
        this.patch.setEnabled(this.mainForm.patchButton.isEnabled());
        this.unpatch.setEnabled(this.mainForm.undoButton.isEnabled());
        this.test.setEnabled(this.mainForm.testButton.isEnabled());
        Config config = Config.getInstance();
        final ProfileManager profileManager = MCPatcher.profileManager;
        this.select.removeAll();
        if (!busy) {
            profiles = new ArrayList<String>();
            profiles.addAll(profileManager.getInputProfiles());
            Collections.sort(profiles);
            ButtonGroup buttonGroup = new ButtonGroup();
            for (final String profile : profiles) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(profile);
                item.setSelected(profile.equals(profileManager.getInputProfile()));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        profileManager.selectInputProfile(profile);
                    }
                });
                this.select.add(item);
                buttonGroup.add(item);
            }
        }
        MainMenu.addIfEmpty(this.select);
        this.delete.removeAll();
        if (!busy) {
            profiles = new ArrayList();
            profiles.addAll(profileManager.getOutputProfiles());
            Collections.sort(profiles);
            final String currentProfile = profileManager.getOutputProfile();
            final DeleteProfileDialog dialog = new DeleteProfileDialog(profileManager);
            for (final String profile : profiles) {
                final Config.ProfileEntry profileEntry = config.profiles.get(profile);
                if (profileEntry == null) continue;
                JMenuItem item = new JMenuItem(profile);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (profile.equals(currentProfile)) {
                            return;
                        }
                        ArrayList<String> versions = new ArrayList<String>();
                        versions.addAll(profileEntry.versions.keySet());
                        dialog.setProfile(profile, versions);
                        int result = JOptionPane.showConfirmDialog(((MainMenu)MainMenu.this).mainForm.frame, dialog.getPanel(), "Confirm profile delete", 0);
                        if (result == 0) {
                            profileManager.deleteProfile(profile, false);
                            dialog.deleteInstallations();
                            MainMenu.this.mainForm.updateProfileLists(profileManager);
                            MainMenu.this.mainForm.updateControls();
                        }
                    }
                });
                item.setEnabled(!profile.equals("MCPatcher") && !profile.equals(currentProfile));
                this.delete.add(item);
            }
        }
        MainMenu.addIfEmpty(this.delete);
    }

    private static void addIfEmpty(JMenuItem menu) {
        MenuElement[] subElements = menu.getSubElements();
        if (subElements == null || subElements.length == 0 || subElements[0].getSubElements().length == 0) {
            JMenuItem item = new JMenuItem("(none)");
            item.setEnabled(false);
            menu.add(item);
        }
    }
}

