/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.prupe.mcpatcher.AddModDialog;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.ConflictDialog;
import com.prupe.mcpatcher.ExternalMod;
import com.prupe.mcpatcher.ForgeAdapter;
import com.prupe.mcpatcher.JTextAreaPrintStream;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MainMenu;
import com.prupe.mcpatcher.MinecraftJar;
import com.prupe.mcpatcher.MinecraftVersion;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.ModList;
import com.prupe.mcpatcher.PatcherException;
import com.prupe.mcpatcher.ProfileManager;
import com.prupe.mcpatcher.UserInterface;
import com.prupe.mcpatcher.converter.TexturePackConverter;
import com.prupe.mcpatcher.converter.TexturePackConverter15;
import com.prupe.mcpatcher.converter.TexturePackConverter16;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.DefaultCaret;

class MainForm
extends UserInterface {
    private static final int TAB_MODS = 0;
    private static final int TAB_OPTIONS = 1;
    private static final int TAB_LOG = 2;
    private static final int TAB_CLASS_MAP = 3;
    private static final int TAB_PATCH_SUMMARY = 4;
    private static final Color MOD_BUSY_COLOR = new Color(192, 192, 192);
    private static final String MOD_DESC_FORMAT1 = "<html><table border=\"0\" cellspacing=\"0\" cellpadding=\"1\" style=\"padding-top: 2px; padding-bottom: 2px; font-weight: normal;\" width=\"%1$d\"><tr><td align=\"left\">%2$s<font size=\"5\"><b>%3$s</b></font></td><td align=\"right\"><b>%4$s</b></td></tr>";
    private static final String MOD_DESC_FORMAT2 = "<tr><td colspan=\"2\"><i>%1$s</i></td></tr>";
    private static final String MOD_DESC_FORMAT3 = "</table></html>";
    private static final String FORCE_CONTINUE_TEXT = "I WILL NOT COMPLAIN IF THIS DOESN'T WORK.";
    private static Image programIcon;
    private JPanel mainPanel;
    final JFrame frame;
    private int frameWidth = 518;
    private final MainMenu mainMenu;
    JButton testButton;
    JButton patchButton;
    JButton undoButton;
    private JTable modTable;
    private JLabel statusText;
    private JProgressBar progressBar;
    private JTabbedPane tabbedPane;
    private JTextArea logText;
    private JButton copyLogButton;
    private JTextArea classMap;
    private JTextArea patchResults;
    private JButton copyClassMapButton;
    private JButton copyPatchResultsButton;
    private JScrollPane modTableScrollPane;
    private JPanel optionsPanel;
    private JScrollPane optionsScrollPane;
    private JScrollPane logScrollPane;
    private JScrollPane classMapScrollPane;
    private JScrollPane patchSummaryScrollPane;
    JButton upButton;
    JButton addButton;
    JButton downButton;
    JButton removeButton;
    JCheckBox setSelectedCheckBox;
    private JComboBox origVersionComboBox;
    private JComboBox outputProfileComboBox;
    private AddModDialog addModDialog;
    static boolean shift;
    private boolean busy = true;
    private boolean updatingProfiles;
    private UIWorker workerThread = null;

    MainForm() {
        this.$$$setupUI$$$();
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(new EventQueue(){
            private boolean reenter;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void dispatchEvent(AWTEvent event) {
                block8: {
                    try {
                        KeyEvent keyEvent;
                        if (event instanceof KeyEvent && (event.getID() == 401 || event.getID() == 402) && (keyEvent = (KeyEvent)event).getKeyCode() == 16) {
                            shift = event.getID() == 401;
                        }
                        super.dispatchEvent(event);
                    }
                    catch (Throwable e) {
                        Logger.log(0);
                        Logger.log(0, "Unexpected error while handling UI event %s", event.toString());
                        Logger.log(e);
                        if (this.reenter) break block8;
                        this.reenter = true;
                        try {
                            MainForm.this.setBusy(false);
                            MainForm.this.tabbedPane.setSelectedIndex(2);
                            MainForm.this.updateActiveTab();
                            MainForm.this.cancelWorker();
                        }
                        catch (Throwable e1) {
                            Logger.log(e1);
                        }
                        finally {
                            this.reenter = false;
                        }
                    }
                }
            }
        });
        this.frame = new JFrame("MCPatcher " + MCPatcher.DISPLAY_VERSION_STRING);
        this.frame.setResizable(true);
        this.frame.setContentPane(this.mainPanel);
        MainForm.setIconImage(this.frame);
        this.frame.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                MainForm.this.cancelWorker();
                MainForm.this.frame.setVisible(false);
                MainForm.this.frame.dispose();
                MCPatcher.saveProperties();
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.frame.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainForm.this.frameWidth = (int)((Component)e.getSource()).getSize().getWidth();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.frame.setMinimumSize(new Dimension(470, 488));
        this.frame.pack();
        this.outputProfileComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (MainForm.this.updatingProfiles || e.getStateChange() != 1) {
                    return;
                }
                String profile = e.getItem().toString();
                ProfileManager profileManager = MCPatcher.profileManager;
                if (profileManager != null && !MCPatcherUtils.isNullOrEmpty(profile)) {
                    if (profileManager.getOutputProfiles().contains(profile)) {
                        profileManager.selectOutputProfile(profile);
                    } else {
                        profileManager.copyCurrentProfile(profile);
                    }
                }
                MainForm.this.refreshMinecraft(false, false);
            }
        });
        this.origVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MainForm.this.updatingProfiles) {
                    return;
                }
                ProfileManager profileManager = MCPatcher.profileManager;
                int index = MainForm.this.origVersionComboBox.getSelectedIndex();
                List<String> versions = profileManager.getInputVersions();
                profileManager.selectInputVersion(versions.get(index));
                MainForm.this.refreshMinecraft(false, false);
            }
        });
        this.setSelectedCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Config.getInstance().selectPatchedProfile = MainForm.this.setSelectedCheckBox.isSelected();
            }
        });
        this.modTable.setRowSelectionAllowed(true);
        this.modTable.setColumnSelectionAllowed(false);
        this.modTable.setAutoResizeMode(3);
        this.setModList(null);
        this.modTableScrollPane.getViewport().setBackground(this.modTable.getBackground());
        this.modTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                MainForm.this.setStatusText("", new Object[0]);
                if (MainForm.this.modTable.isEnabled()) {
                    int row = MainForm.this.modTable.getSelectedRow();
                    int col = MainForm.this.modTable.getSelectedColumn();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    Mod mod = (Mod)model.getValueAt(row, col);
                    if (col == 0 && mod != null && mod.okToApply()) {
                        MCPatcher.modList.selectMod(mod, !mod.isEnabled());
                    }
                    model.fireTableRowsUpdated(0, model.getRowCount());
                    if (e.getClickCount() == 2 && mod instanceof ExternalMod) {
                        ExternalMod extMod = (ExternalMod)mod;
                        MainForm.this.addModDialog = new AddModDialog(MainForm.this.mainPanel, extMod);
                        if (MainForm.this.addModDialog.showFileListDialog() && MainForm.this.addModDialog.getMod() == extMod) {
                            MainForm.this.modTable.addRowSelectionInterval(row, row);
                            ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                            renderer.resetRowHeights();
                            model.fireTableDataChanged();
                        }
                    }
                }
                super.mouseClicked(e);
            }
        });
        this.upButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = MainForm.this.modTable.getSelectedRow();
                if (row >= 0) {
                    int newRow = MCPatcher.modList.moveUp(row, shift);
                    MainForm.this.modTable.clearSelection();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    model.fireTableRowsUpdated(Math.min(row, newRow), Math.max(row, newRow));
                    ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                    renderer.resetRowHeights();
                    MainForm.this.modTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        });
        this.downButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = MainForm.this.modTable.getSelectedRow();
                if (row >= 0) {
                    int newRow = MCPatcher.modList.moveDown(row, shift);
                    MainForm.this.modTable.clearSelection();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    model.fireTableRowsUpdated(Math.min(row, newRow), Math.max(row, newRow));
                    ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                    renderer.resetRowHeights();
                    MainForm.this.modTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MainForm.this.addModDialog = new AddModDialog(MainForm.this.mainPanel);
                    File path = MainForm.this.addModDialog.showBrowseDialog();
                    if (path == null) {
                        return;
                    }
                    if (ExternalMod.isValidPath(path) && MainForm.this.addModDialog.showFileListDialog()) {
                        this.addMod(MainForm.this.addModDialog.getMod());
                    }
                }
                catch (Throwable e1) {
                    Logger.log(e1);
                }
                finally {
                    this.hideDialog();
                    MainForm.this.updateControls();
                }
            }

            private void hideDialog() {
                if (MainForm.this.addModDialog != null) {
                    MainForm.this.addModDialog.setVisible(false);
                    MainForm.this.addModDialog.dispose();
                    MainForm.this.addModDialog = null;
                }
            }

            private void addMod(Mod mod) {
                if (mod != null) {
                    int row = MCPatcher.modList.addFirstBuiltin(mod);
                    mod.setEnabled(true);
                    MainForm.this.modTable.clearSelection();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    model.fireTableRowsInserted(row, row);
                    ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                    renderer.resetRowHeights();
                }
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = MainForm.this.modTable.getSelectedRow();
                Mod mod = (Mod)MainForm.this.modTable.getModel().getValueAt(row, 0);
                if (mod instanceof ExternalMod || mod instanceof ForgeAdapter) {
                    MCPatcher.modList.remove(mod);
                    MainForm.this.modTable.clearSelection();
                    AbstractTableModel model = (AbstractTableModel)MainForm.this.modTable.getModel();
                    model.fireTableRowsDeleted(row, row);
                    if (row >= model.getRowCount()) {
                        --row;
                    }
                    MainForm.this.modTable.addRowSelectionInterval(row, row);
                    ModTextRenderer renderer = (ModTextRenderer)MainForm.this.modTable.getColumnModel().getColumn(1).getCellRenderer();
                    renderer.resetRowHeights();
                }
            }
        });
        this.patchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ConflictDialog dialog;
                int result;
                HashMap<String, ArrayList<Mod>> conflicts;
                if (MCPatcher.minecraft.isModded()) {
                    String answer;
                    do {
                        if ((answer = JOptionPane.showInputDialog(MainForm.this.frame, MainForm.getModWarningText(MCPatcher.minecraft.getVersion()) + "\n\n" + "However, if you understand the risks and wish to continue patching anyway, type\n" + "    " + MainForm.FORCE_CONTINUE_TEXT + "\n" + "in the box below with the exact same capitalization and punctuation.", "Warning", 2)) != null && !answer.equals("")) continue;
                        return;
                    } while (!MainForm.FORCE_CONTINUE_TEXT.equals(answer));
                }
                if (!(conflicts = MCPatcher.getConflicts()).isEmpty() && (result = (dialog = new ConflictDialog(conflicts)).getResult(MainForm.this.mainPanel)) != 0) {
                    return;
                }
                MainForm.this.runWorker(new UIWorker("Patch"){

                    @Override
                    void runImpl() throws Exception {
                        MCPatcher.patch();
                    }
                });
            }
        });
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.setStatusText("", new Object[0]);
                ProfileManager profileManager = MCPatcher.profileManager;
                profileManager.deleteProfile(profileManager.getOutputProfile(), true);
                MinecraftJar.setDefaultTexturePack();
                JOptionPane.showMessageDialog(MainForm.this.frame, String.format("Removed %s\nand reset texture pack to default.", profileManager.getOutputJar().getParentFile()), "", 1);
                MainForm.this.updateControls();
            }
        });
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainForm.this.tabbedPane.setSelectedIndex(2);
                MainForm.this.runWorker(new UIWorker("Launch game"){

                    @Override
                    void runImpl() throws Exception {
                        MainForm.this.setStatusText("Launching %s...", MCPatcher.minecraft.getOutputFile().getName());
                        MCPatcher.saveProperties();
                        MCPatcher.minecraft.run();
                    }
                });
            }
        });
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainForm.this.updateActiveTab();
                MCPatcher.saveProperties();
            }
        });
        ((DefaultCaret)this.logText.getCaret()).setUpdatePolicy(2);
        JTextAreaPrintStream output = new JTextAreaPrintStream(this.logText);
        System.setOut(output);
        System.setErr(output);
        this.copyLogButton.addActionListener(new CopyToClipboardListener(this.logText));
        ((DefaultCaret)this.classMap.getCaret()).setUpdatePolicy(1);
        this.copyClassMapButton.addActionListener(new CopyToClipboardListener(this.classMap));
        ((DefaultCaret)this.patchResults.getCaret()).setUpdatePolicy(1);
        this.copyPatchResultsButton.addActionListener(new CopyToClipboardListener(this.patchResults));
        this.modTableScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.optionsScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.logScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.classMapScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.patchSummaryScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.mainMenu = new MainMenu(this);
        this.frame.setJMenuBar(this.mainMenu.menuBar);
        this.setSelectedCheckBox.requestFocusInWindow();
    }

    private static String getModWarningText(MinecraftVersion version) {
        return "Your minecraft.jar appears to be already modded.\nIt is highly recommended that you install mods via MCPatcher instead.\n - Close MCPatcher.\n - Re-download " + version.getVersionString() + " using the launcher.\n" + " - Run MCPatcher and select mods to add using the Add (+) button in the main window.\n" + "This will prevent most conflicts between MCPatcher and other mods.";
    }

    static void setIconImage(Window window) {
        try {
            if (programIcon == null) {
                programIcon = Toolkit.getDefaultToolkit().getImage(MainForm.class.getResource("/resources/icon.png"));
            }
            window.setIconImage(programIcon);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    boolean shouldExit() {
        return false;
    }

    @Override
    boolean go(ProfileManager profileManager) {
        this.refreshMinecraft(true, false);
        return true;
    }

    @Override
    void show() {
        this.setSelectedCheckBox.setSelected(Config.getInstance().selectPatchedProfile);
        this.frame.setLocationRelativeTo(null);
        this.frame.setVisible(true);
    }

    @Override
    File chooseMinecraftDir(File minecraftDir) {
        PatcherException.InstallationNotFound exception = new PatcherException.InstallationNotFound(minecraftDir);
        JOptionPane.showMessageDialog(null, ((PatcherException)exception).getMessageBoxText(), ((PatcherException)exception).getMessageBoxTitle(), 0);
        JFileChooser fd = new JFileChooser();
        fd.setFileSelectionMode(1);
        fd.setFileHidingEnabled(false);
        fd.setDialogTitle("Select Minecraft directory");
        int result = fd.showDialog(null, null);
        if (result != 0) {
            return null;
        }
        return fd.getSelectedFile();
    }

    @Override
    void showBetaWarning() {
        JOptionPane.showMessageDialog(this.frame, "This is a pre-release version of MCPatcher and is not intended\nfor general use.\n\nPlease make backups of your mods, save files, and texture packs\nbefore using.  Report any problems in the thread for MCPatcher beta at\nhttp://www.minecraftforum.net/topic/1496369-", "For testing only", 1);
    }

    void showTexturePackConverter(int version) {
        JFileChooser fd = new JFileChooser();
        fd.setFileSelectionMode(0);
        fd.setFileHidingEnabled(false);
        fd.setDialogTitle("Select texture pack");
        fd.setCurrentDirectory(MCPatcherUtils.getMinecraftPath("texturepacks"));
        fd.setAcceptAllFileFilterUsed(false);
        fd.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".zip") && !name.startsWith("mcpatcher-converted-");
            }

            @Override
            public String getDescription() {
                return "texture packs (*.zip)";
            }
        });
        if (fd.showOpenDialog(this.frame) == 0) {
            int result;
            TexturePackConverter converter;
            final File selectedFile = fd.getSelectedFile();
            TexturePackConverter texturePackConverter = converter = version == 16 ? new TexturePackConverter16(selectedFile) : new TexturePackConverter15(selectedFile);
            if (converter.getOutputFile().exists() && (result = JOptionPane.showConfirmDialog(this.frame, String.format("This will overwrite\n%s\n\nContinue?", converter.getOutputFile().getAbsolutePath()), "Confirm overwrite", 0)) != 0) {
                return;
            }
            this.tabbedPane.setSelectedIndex(2);
            this.runWorker(new UIWorker("Convert"){
                private boolean result;

                @Override
                void runImpl() {
                    this.result = converter.convert(MainForm.this);
                }

                @Override
                void updateUI() {
                    StringBuilder sb = new StringBuilder();
                    for (String s : converter.getMessages()) {
                        sb.append(s).append('\n');
                    }
                    if (!this.success() || !this.result) {
                        JOptionPane.showMessageDialog(MainForm.this.frame, sb.toString(), "Error converting " + selectedFile.getName(), 0);
                    } else if (sb.length() > 0) {
                        JOptionPane.showMessageDialog(MainForm.this.frame, sb.toString(), "Warnings while converting " + selectedFile.getName(), 2);
                    } else {
                        JOptionPane.showMessageDialog(MainForm.this.frame, "Successfully converted " + selectedFile.getName() + ".\n" + converter.getOutputMessage(), "Done", 1);
                    }
                }
            });
        }
    }

    void refreshMinecraft(final boolean refreshProfileManager, final boolean forceRemote) {
        final ProfileManager profileManager = MCPatcher.profileManager;
        if (profileManager == null) {
            return;
        }
        this.runWorker(new UIWorker("Analyze"){

            @Override
            void runImpl() throws Exception {
                if (refreshProfileManager) {
                    profileManager.refresh(MainForm.this, forceRemote);
                }
                MainForm.runInEventThread(new Runnable(){

                    @Override
                    public void run() {
                        MainForm.this.updateProfileLists(profileManager);
                    }
                });
                MCPatcher.refreshMinecraftPath();
                MainForm.runInEventThread(new Runnable(){

                    @Override
                    public void run() {
                        MainForm.this.setModList(null);
                    }
                });
                if (forceRemote) {
                    ModList.legacyVersionList = null;
                }
                MCPatcher.refreshModList();
                MainForm.runInEventThread(new Runnable(){

                    @Override
                    public void run() {
                        MainForm.this.setModList(MCPatcher.modList);
                    }
                });
                MCPatcher.checkModApplicability();
                MCPatcher.saveProperties();
            }

            @Override
            void updateUI() {
                MainForm.this.redrawModList();
                if (this.success() && MCPatcher.minecraft.isModded()) {
                    JOptionPane.showMessageDialog(MainForm.this.frame, MainForm.getModWarningText(MCPatcher.minecraft.getVersion()), "Warning", 2);
                }
            }
        });
    }

    private void cancelWorker() {
        if (this.workerThread != null && this.workerThread.isAlive()) {
            try {
                this.workerThread.interrupt();
                this.setStatusText("Waiting for current task to finish...", new Object[0]);
                this.workerThread.join();
            }
            catch (InterruptedException e) {
                Logger.log(e);
            }
            this.setStatusText("", new Object[0]);
        }
        this.workerThread = null;
    }

    private void runWorker(UIWorker worker) {
        this.setBusy(true);
        if (Thread.currentThread().equals(this.workerThread)) {
            worker.run();
        } else {
            this.cancelWorker();
            this.workerThread = worker;
            this.workerThread.start();
        }
    }

    private static void runInEventThread(Runnable task) {
        if (SwingUtilities.isEventDispatchThread()) {
            task.run();
        } else {
            SwingUtilities.invokeLater(task);
        }
    }

    void setBusy(final boolean busy) {
        this.busy = busy;
        MainForm.runInEventThread(new Runnable(){

            @Override
            public void run() {
                if (!busy) {
                    MainForm.this.setStatusText("", new Object[0]);
                    MainForm.this.updateProgress(0, 0);
                }
                MainForm.this.updateControls();
            }
        });
    }

    @Override
    public void setStatusText(final String format, final Object ... params) {
        MainForm.runInEventThread(new Runnable(){

            @Override
            public void run() {
                MainForm.this.statusText.setText(String.format(format, params));
            }
        });
    }

    @Override
    public void updateProgress(final int value, final int max) {
        MainForm.runInEventThread(new Runnable(){

            @Override
            public void run() {
                if (max > 0) {
                    MainForm.this.progressBar.setVisible(true);
                    MainForm.this.progressBar.setMinimum(0);
                    MainForm.this.progressBar.setMaximum(max);
                    MainForm.this.progressBar.setValue(value);
                } else {
                    MainForm.this.progressBar.setVisible(false);
                    MainForm.this.progressBar.setMinimum(0);
                    MainForm.this.progressBar.setMaximum(1);
                    MainForm.this.progressBar.setValue(0);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateProfileLists(ProfileManager profileManager) {
        try {
            this.updatingProfiles = true;
            StringBuilder sb = new StringBuilder();
            this.outputProfileComboBox.removeAllItems();
            if (profileManager != null) {
                for (String s : profileManager.getOutputProfiles()) {
                    this.outputProfileComboBox.addItem(s);
                }
                this.outputProfileComboBox.setSelectedIndex(profileManager.getSelectedOutputProfileIndex());
            }
            this.origVersionComboBox.removeAllItems();
            if (profileManager != null) {
                for (String s : profileManager.getInputVersions()) {
                    this.origVersionComboBox.addItem(s);
                }
                this.origVersionComboBox.setSelectedIndex(profileManager.getSelectedInputVersionIndex());
                File path = profileManager.getInputJar();
                if (path != null) {
                    sb.append("<b>Input file:</b> ");
                    sb.append(path.getAbsolutePath());
                }
                if ((path = profileManager.getOutputJar()) != null) {
                    if (sb.length() > 0) {
                        sb.append("<br>");
                    }
                    sb.append("<b>Output file:</b> ");
                    sb.append(path.getAbsolutePath());
                }
            }
            if (sb.length() > 0) {
                this.origVersionComboBox.setToolTipText("<html>" + sb.toString());
            } else {
                this.origVersionComboBox.setToolTipText(null);
            }
        }
        finally {
            this.updatingProfiles = false;
        }
    }

    void updateControls() {
        ProfileManager profileManager = MCPatcher.profileManager;
        String currentVersion = null;
        if (profileManager != null && profileManager.isReady()) {
            currentVersion = profileManager.getInputVersion();
        }
        if (MCPatcherUtils.isNullOrEmpty(currentVersion)) {
            this.frame.setTitle("MCPatcher " + MCPatcher.DISPLAY_VERSION_STRING);
        } else {
            this.frame.setTitle("MCPatcher " + MCPatcher.DISPLAY_VERSION_STRING + " [Minecraft " + currentVersion + "]");
        }
        boolean inputOk = false;
        boolean outputOk = false;
        if (profileManager != null && profileManager.isReady()) {
            File path = profileManager.getInputJar();
            inputOk = path != null && path.isFile();
            path = profileManager.getOutputJar();
            outputOk = path != null && path.isFile();
        }
        this.outputProfileComboBox.setEnabled(!this.busy);
        this.origVersionComboBox.setEnabled(!this.busy);
        this.setSelectedCheckBox.setEnabled(!this.busy);
        this.setSelectedCheckBox.setSelected(Config.getInstance().selectPatchedProfile);
        this.modTable.setEnabled(!this.busy && inputOk);
        this.upButton.setEnabled(!this.busy && inputOk);
        this.downButton.setEnabled(!this.busy && inputOk);
        this.addButton.setEnabled(!this.busy && inputOk);
        this.removeButton.setEnabled(!this.busy && inputOk);
        this.testButton.setEnabled(!this.busy && outputOk && MCPatcherUtils.getMinecraftPath(new String[0]).equals(MCPatcherUtils.getDefaultGameDir()));
        this.patchButton.setEnabled(!this.busy && inputOk);
        this.undoButton.setEnabled(!this.busy && outputOk);
        this.tabbedPane.setEnabled(!this.busy);
        this.updateActiveTab();
        this.mainMenu.updateControls(this.busy);
    }

    private void updateActiveTab() {
        if (this.tabbedPane.getSelectedIndex() != 1) {
            this.saveOptions();
        }
        switch (this.tabbedPane.getSelectedIndex()) {
            case 1: {
                this.loadOptions();
                break;
            }
            case 3: {
                this.showClassMaps();
                break;
            }
            case 4: {
                this.showPatchResults();
                break;
            }
        }
    }

    private void saveOptions() {
        if (MCPatcher.modList != null) {
            for (Mod mod : MCPatcher.modList.getAll()) {
                if (mod.configPanel == null) continue;
                try {
                    mod.configPanel.save();
                }
                catch (Throwable e) {
                    Logger.log(e);
                }
            }
        }
    }

    private void loadOptions() {
        this.optionsPanel.removeAll();
        this.optionsPanel.setLayout(new BoxLayout(this.optionsPanel, 1));
        if (MCPatcher.modList != null) {
            for (Mod mod : MCPatcher.modList.getAll()) {
                try {
                    if (mod.configPanel == null) continue;
                    mod.loadOptions();
                    JPanel panel = mod.configPanel.getPanel();
                    if (panel == null) continue;
                    String name = mod.configPanel.getPanelName();
                    if (name == null) {
                        name = mod.getName();
                    }
                    if (panel.getParent() != null) {
                        panel.getParent().remove(panel);
                    }
                    panel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), name));
                    this.optionsPanel.add(panel);
                    this.optionsPanel.add(Box.createRigidArea(new Dimension(1, 16)));
                }
                catch (Throwable e) {
                    Logger.log(e);
                }
            }
        }
        this.optionsPanel.validate();
    }

    private void showClassMaps() {
        this.classMap.setText("");
        JTextAreaPrintStream out = new JTextAreaPrintStream(this.classMap);
        MCPatcher.showClassMaps(out);
        out.close();
    }

    private void showPatchResults() {
        this.patchResults.setText("");
        JTextAreaPrintStream out = new JTextAreaPrintStream(this.patchResults);
        MCPatcher.showPatchResults(out);
        out.close();
    }

    void setModList(final ModList modList) {
        this.modTable.setModel(new DefaultTableModel(){

            @Override
            public int getRowCount() {
                return modList == null ? 0 : modList.getVisible().size();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public String getColumnName(int columnIndex) {
                return null;
            }

            @Override
            public Class<?> getColumnClass(int columnIndex) {
                return Mod.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (modList == null || rowIndex < 0) {
                    return null;
                }
                List<Mod> visible = modList.getVisible();
                return rowIndex < visible.size() ? visible.get(rowIndex) : null;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            }
        });
        this.redrawModList();
    }

    void redrawModList() {
        this.modTable.getColumnModel().getColumn(0).setCellRenderer(new ModCheckBoxRenderer());
        this.modTable.getColumnModel().getColumn(1).setCellRenderer(new ModTextRenderer());
        AbstractTableModel model = (AbstractTableModel)this.modTable.getModel();
        model.fireTableDataChanged();
    }

    void redrawModListCheckboxes() {
        AbstractTableModel model = (AbstractTableModel)this.modTable.getModel();
        model.fireTableChanged(new TableModelEvent(model, 0, this.modTable.getRowCount(), 0));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JCheckBox jCheckBox;
        JButton jButton;
        JTextArea jTextArea;
        JScrollPane jScrollPane;
        JButton jButton2;
        JTextArea jTextArea2;
        JScrollPane jScrollPane2;
        JButton jButton3;
        JTextArea jTextArea3;
        JScrollPane jScrollPane3;
        JPanel jPanel;
        JScrollPane jScrollPane4;
        JButton jButton4;
        JButton jButton5;
        JButton jButton6;
        JButton jButton7;
        JButton jButton8;
        JButton jButton9;
        JButton jButton10;
        JTable jTable;
        JScrollPane jScrollPane5;
        JTabbedPane jTabbedPane;
        JProgressBar jProgressBar;
        JLabel jLabel;
        JPanel jPanel2;
        this.mainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(4, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel2.setOpaque(true);
        jPanel2.setPreferredSize(new Dimension(512, 512));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, new Dimension(-1, 32), null));
        jPanel3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), null, 0, 0, null, null));
        this.statusText = jLabel = new JLabel();
        jLabel.setText("");
        ((Component)jLabel).setEnabled(true);
        jPanel3.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.progressBar = jProgressBar = new JProgressBar();
        jProgressBar.setStringPainted(true);
        jPanel3.add((Component)jProgressBar, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, new Dimension(200, -1), null));
        this.tabbedPane = jTabbedPane = new JTabbedPane();
        jPanel2.add((Component)jTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Mods", null, jPanel4, "Select mods to apply");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.modTableScrollPane = jScrollPane5 = new JScrollPane();
        jPanel5.add((Component)jScrollPane5, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, new Dimension(-1, 225), null, null));
        this.modTable = jTable = new JTable();
        jTable.setIntercellSpacing(new Dimension(0, 0));
        jTable.setShowVerticalLines(false);
        jTable.setPreferredScrollableViewportSize(new Dimension(-1, -1));
        jTable.setAutoResizeMode(3);
        jTable.setShowHorizontalLines(false);
        ((Component)jTable).setEnabled(false);
        jScrollPane5.setViewportView(jTable);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.undoButton = jButton10 = new JButton();
        jButton10.setText("Unpatch");
        jButton10.setMnemonic('U');
        jButton10.setDisplayedMnemonicIndex(0);
        jButton10.setToolTipText("Restore original minecraft.jar");
        ((Component)jButton10).setEnabled(false);
        jPanel6.add((Component)jButton10, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.patchButton = jButton9 = new JButton();
        jButton9.setText("Patch");
        jButton9.setMnemonic('P');
        jButton9.setDisplayedMnemonicIndex(0);
        jButton9.setToolTipText("Apply selected mods");
        ((Component)jButton9).setEnabled(false);
        jPanel6.add((Component)jButton9, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 0, null, null, null));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, true, true));
        jPanel6.add((Component)jPanel7, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.upButton = jButton8 = new JButton();
        jButton8.setToolTipText("<html>Move selected item up the list<br>(Shift-click: Move to top)</html>");
        jButton8.setIcon(new ImageIcon(this.getClass().getResource("/resources/uparrow.png")));
        ((Component)jButton8).setEnabled(false);
        jPanel7.add((Component)jButton8, new GridConstraints(0, 0, 1, 1, 0, 1, 1, 0, null, null, null));
        this.addButton = jButton7 = new JButton();
        jButton7.setToolTipText("Add an external zip-based mod");
        jButton7.setIcon(new ImageIcon(this.getClass().getResource("/resources/add.png")));
        ((Component)jButton7).setEnabled(false);
        jPanel7.add((Component)jButton7, new GridConstraints(0, 2, 1, 1, 0, 1, 1, 0, null, null, null));
        this.downButton = jButton6 = new JButton();
        jButton6.setToolTipText("<html>Move selected item down the list<br>(Shift-click: Move to bottom)</html>");
        jButton6.setIcon(new ImageIcon(this.getClass().getResource("/resources/downarrow.png")));
        ((Component)jButton6).setEnabled(false);
        jPanel7.add((Component)jButton6, new GridConstraints(0, 1, 1, 1, 0, 1, 1, 0, null, null, null));
        this.removeButton = jButton5 = new JButton();
        jButton5.setToolTipText("Remove the selected item");
        jButton5.setIcon(new ImageIcon(this.getClass().getResource("/resources/remove.png")));
        ((Component)jButton5).setEnabled(false);
        jPanel7.add((Component)jButton5, new GridConstraints(0, 3, 1, 1, 0, 1, 1, 0, null, null, null));
        this.testButton = jButton4 = new JButton();
        jButton4.setText("Test Minecraft");
        jButton4.setMnemonic('T');
        jButton4.setDisplayedMnemonicIndex(0);
        jButton4.setToolTipText("Test Minecraft (single-player only)");
        ((Component)jButton4).setEnabled(false);
        jPanel6.add((Component)jButton4, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Options", null, jPanel8, "Configure animations, etc.");
        this.optionsScrollPane = jScrollPane4 = new JScrollPane();
        jPanel8.add((Component)jScrollPane4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jScrollPane4.setViewportView(jPanel9);
        this.optionsPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel9.add((Component)jPanel, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel9.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel9.add((Component)spacer3, new GridConstraints(0, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel9.add((Component)spacer4, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Log", null, jPanel10, "View detailed log output");
        this.logScrollPane = jScrollPane3 = new JScrollPane();
        jPanel10.add((Component)jScrollPane3, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.logText = jTextArea3 = new JTextArea();
        jTextArea3.setEditable(false);
        jTextArea3.setLineWrap(true);
        jScrollPane3.setViewportView(jTextArea3);
        this.copyLogButton = jButton3 = new JButton();
        jButton3.setText("Copy to clipboard");
        jPanel10.add((Component)jButton3, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Class Map", null, jPanel11, "View mapping to obfuscated names");
        this.classMapScrollPane = jScrollPane2 = new JScrollPane();
        jPanel11.add((Component)jScrollPane2, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.classMap = jTextArea2 = new JTextArea();
        jTextArea2.setEditable(false);
        jTextArea2.setLineWrap(true);
        jScrollPane2.setViewportView(jTextArea2);
        this.copyClassMapButton = jButton2 = new JButton();
        jButton2.setText("Copy to clipboard");
        jPanel11.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel12 = new JPanel();
        jPanel12.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jTabbedPane.addTab("Patch Summary", null, jPanel12, "View list of patches applied");
        this.patchSummaryScrollPane = jScrollPane = new JScrollPane();
        jPanel12.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.patchResults = jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jScrollPane.setViewportView(jTextArea);
        this.copyPatchResultsButton = jButton = new JButton();
        jButton.setText("Copy to clipboard");
        jPanel12.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel13 = new JPanel();
        jPanel13.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel13, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        jPanel13.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Minecraft Profile", 0, 0, null, null));
        this.setSelectedCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Set as selected profile in launcher");
        jCheckBox.setSelected(true);
        jPanel13.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel14 = new JPanel();
        jPanel14.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel13.add((Component)jPanel14, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("New profile");
        jPanel14.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Game version");
        jPanel14.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.origVersionComboBox = jComboBox2 = new JComboBox();
        jPanel14.add(jComboBox2, new GridConstraints(0, 3, 1, 1, 8, 1, 3, 0, null, new Dimension(120, -1), null));
        this.outputProfileComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(true);
        jPanel14.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, new Dimension(80, -1), new Dimension(120, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.mainPanel;
    }

    private abstract class UIWorker
    extends Thread {
        protected Throwable error;
        protected boolean interrupted;

        UIWorker(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public final void run() {
            this.error = null;
            this.interrupted = false;
            try {
                this.runImpl();
            }
            catch (InterruptedException e) {
                this.interrupted = true;
                MainForm.runInEventThread(new Runnable(){

                    @Override
                    public void run() {
                        UIWorker.this.finish();
                    }
                });
            }
            catch (Throwable e2) {
                Logger.log(e2);
                this.error = e2;
                {
                    catch (Throwable throwable) {
                        MainForm.runInEventThread(new /* invalid duplicate definition of identical inner class */);
                        throw throwable;
                    }
                }
                MainForm.runInEventThread(new /* invalid duplicate definition of identical inner class */);
            }
            MainForm.runInEventThread(new /* invalid duplicate definition of identical inner class */);
        }

        final void finish() {
            this.updateUI();
            MainForm.this.setBusy(false);
            if (this.error != null) {
                MainForm.this.tabbedPane.setSelectedIndex(2);
                this.showErrorMessage();
            }
        }

        private void showErrorMessage() {
            if (this.error instanceof PatcherException) {
                JOptionPane.showMessageDialog(MainForm.this.frame, ((PatcherException)this.error).getMessageBoxText(), ((PatcherException)this.error).getMessageBoxTitle(), 0);
            } else if (this.error != null) {
                JOptionPane.showMessageDialog(MainForm.this.frame, "An unexpected error occurred.\n\n" + this.error + "\n\n" + "Check the Log tab for more information.", "Error", 0);
            }
        }

        boolean success() {
            return this.error == null && !this.interrupted;
        }

        void updateUI() {
        }

        abstract void runImpl() throws Exception;
    }

    private class CopyToClipboardListener
    implements ActionListener {
        final JTextArea textArea;

        public CopyToClipboardListener(JTextArea textArea) {
            this.textArea = textArea;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(new StringSelection("[spoiler][code]\n" + this.textArea.getText() + "[/code][/spoiler]\n"), null);
        }
    }

    private class ModTextRenderer
    extends JLabel
    implements TableCellRenderer {
        private final HashMap<Integer, Integer> rowSizeFull = new HashMap();
        private final HashMap<Integer, Integer> rowSizeShort = new HashMap();

        private ModTextRenderer() {
        }

        private String htmlEscape(String s) {
            return s == null ? "" : s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }

        public void resetRowHeights() {
            this.rowSizeFull.clear();
            this.rowSizeShort.clear();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int h;
            if (!(value instanceof Mod)) {
                Logger.log(0, "table cell %d,%d is of wrong type %s", row, column, value == null ? "(null)" : value.getClass().getName());
                return this;
            }
            Mod mod = (Mod)value;
            HashMap<Integer, Integer> rowSize = this.rowSizeFull;
            boolean rowSelected = row == table.getSelectedRow();
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(MainForm.MOD_DESC_FORMAT1, Math.max(MainForm.this.frameWidth - 75, 350), mod.experimental ? "<font color=\"red\" size=\"3\">(Experimental)</font> " : "", this.htmlEscape(mod.getName()), this.htmlEscape(mod.getVersion())));
            if (rowSelected) {
                rowSize = this.rowSizeShort;
                sb.append(String.format(MainForm.MOD_DESC_FORMAT2, this.htmlEscape(mod.getDescription())));
            }
            sb.append(MainForm.MOD_DESC_FORMAT3);
            this.setText(sb.toString());
            if (!table.isEnabled() || !mod.okToApply()) {
                this.setBackground(table.getBackground());
                this.setForeground(MOD_BUSY_COLOR);
            } else if (rowSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setEnabled(table.isEnabled() && mod.okToApply());
            if (rowSize.containsKey(row)) {
                h = rowSize.get(row);
            } else {
                h = (int)this.getPreferredSize().getHeight();
                rowSize.put(row, h);
            }
            if (h != table.getRowHeight(row)) {
                table.setRowHeight(row, h);
            }
            ArrayList<String> errors = mod.getErrors();
            sb = new StringBuilder();
            if (table.isEnabled()) {
                if (errors.size() == 0) {
                    String author = this.htmlEscape(mod.getAuthor());
                    String website = this.htmlEscape(mod.getWebsite());
                    if (author.length() > 0 || website.length() > 0) {
                        sb.append("<html>");
                        if (mod.getAuthor().length() > 0) {
                            sb.append(String.format("Author: %s<br>", author));
                        }
                        if (mod.getWebsite().length() > 0) {
                            sb.append(String.format("Website: <a href=\"%1$s\">%1$s</a><br>", website));
                        }
                        sb.append("</html>");
                    }
                } else {
                    sb.append("<html><b>");
                    sb.append(this.htmlEscape(mod.getName()));
                    sb.append(" cannot be applied:</b><br>");
                    for (String s : errors) {
                        sb.append("&nbsp;");
                        sb.append(s);
                        sb.append("<br>");
                    }
                    sb.append("</html>");
                }
            }
            this.setToolTipText(sb.length() == 0 ? null : sb.toString());
            this.setOpaque(true);
            return this;
        }
    }

    private class ModCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private boolean widthSet = false;

        private ModCheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (!(value instanceof Mod)) {
                Logger.log(0, "table cell %d,%d is of wrong type %s", row, column, value == null ? "(null)" : value.getClass().getName());
                return this;
            }
            Mod mod = (Mod)value;
            if (!table.isEnabled() || !mod.okToApply()) {
                this.setBackground(table.getBackground());
                this.setForeground(MOD_BUSY_COLOR);
            } else if (row == table.getSelectedRow()) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setSelected(mod.isEnabled());
            this.setEnabled(table.isEnabled() && mod.okToApply());
            if (!this.widthSet) {
                TableColumn col = table.getColumnModel().getColumn(column);
                double width = this.getPreferredSize().getWidth();
                col.setMinWidth((int)width);
                col.setMaxWidth((int)(1.5 * width));
                col.setPreferredWidth((int)(1.5 * width));
                this.widthSet = true;
            }
            return this;
        }
    }
}

