/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.Config;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;

public class MCPatcherUtils {
    private static File minecraftDir;
    private static File gameDir;
    private static boolean isGame;
    private static String minecraftVersion;
    private static String patcherVersion;
    private static Properties patcherProperties;
    public static final String EXTENDED_HD = "Extended HD";
    public static final String HD_TEXTURES = "HD Textures";
    public static final String HD_FONT = "HD Font";
    public static final String RANDOM_MOBS = "Random Mobs";
    public static final String CUSTOM_COLORS = "Custom Colors";
    public static final String CONNECTED_TEXTURES = "Connected Textures";
    public static final String BETTER_SKIES = "Better Skies";
    public static final String BETTER_GRASS = "Better Grass";
    public static final String BETTER_GLASS = "Better Glass";
    public static final String CUSTOM_ITEM_TEXTURES = "Custom Item Textures";
    public static final String GLSL_SHADERS = "GLSL Shaders";
    public static final String BASE_MOD = "__Base";
    public static final String BASE_TEXTURE_PACK_MOD = "__TexturePackBase";
    public static final String BASE_TILESHEET_MOD = "__TilesheetBase";
    public static final String NBT_MOD = "__NBT";
    public static final String BLOCK_API_MOD = "__BlockAPI";
    public static final String ITEM_API_MOD = "__ItemAPI";
    public static final String BIOME_API_MOD = "__BiomeAPI";
    public static final String CUSTOM_ANIMATIONS = "Custom Animations";
    public static final String MIPMAP = "Mipmap";
    public static final String GL11_CLASS = "org.lwjgl.opengl.GL11";
    public static final String UTILS_CLASS = "com.prupe.mcpatcher.MCPatcherUtils";
    public static final String LOGGER_CLASS = "com.prupe.mcpatcher.MCLogger";
    public static final String CONFIG_CLASS = "com.prupe.mcpatcher.Config";
    public static final String JSON_UTILS_CLASS = "com.prupe.mcpatcher.JsonUtils";
    public static final String PROFILER_API_CLASS = "com.prupe.mcpatcher.ProfilerAPI";
    public static final String INPUT_HANDLER_CLASS = "com.prupe.mcpatcher.InputHandler";
    public static final String MAL_CLASS = "com.prupe.mcpatcher.MAL";
    public static final String TEXTURE_PACK_API_CLASS = "com.prupe.mcpatcher.TexturePackAPI";
    public static final String TEXTURE_PACK_CHANGE_HANDLER_CLASS = "com.prupe.mcpatcher.TexturePackChangeHandler";
    public static final String WEIGHTED_INDEX_CLASS = "com.prupe.mcpatcher.WeightedIndex";
    public static final String BLEND_METHOD_CLASS = "com.prupe.mcpatcher.BlendMethod";
    public static final String TILE_LOADER_CLASS = "com.prupe.mcpatcher.TileLoader";
    public static final String TESSELLATOR_UTILS_CLASS = "com.prupe.mcpatcher.TessellatorUtils";
    public static final String AA_HELPER_CLASS = "com.prupe.mcpatcher.hd.AAHelper";
    public static final String BORDERED_TEXTURE_CLASS = "com.prupe.mcpatcher.hd.BorderedTexture";
    public static final String CUSTOM_ANIMATION_CLASS = "com.prupe.mcpatcher.hd.CustomAnimation";
    public static final String FANCY_DIAL_CLASS = "com.prupe.mcpatcher.hd.FancyDial";
    public static final String FONT_UTILS_CLASS = "com.prupe.mcpatcher.hd.FontUtils";
    public static final String MIPMAP_HELPER_CLASS = "com.prupe.mcpatcher.hd.MipmapHelper";
    public static final String FANCY_COMPASS_CLASS = "com.prupe.mcpatcher.hd.FancyCompass";
    public static final String TEXTURE_UTILS_CLASS = "com.prupe.mcpatcher.hd.TextureUtils";
    public static final String TILE_SIZE_CLASS = "com.prupe.mcpatcher.hd.TileSize";
    public static final String BLOCK_API_CLASS = "com.prupe.mcpatcher.mal.block.BlockAPI";
    public static final String RENDER_PASS_API_MAL_CLASS = "com.prupe.mcpatcher.mal.block.RenderPassAPI";
    public static final String RENDER_BLOCKS_UTILS_CLASS = "com.prupe.mcpatcher.mal.block.RenderBlocksUtils";
    public static final String ITEM_API_CLASS = "com.prupe.mcpatcher.mal.item.ItemAPI";
    public static final String NBT_RULE_CLASS = "com.prupe.mcpatcher.mal.nbt.NBTRule";
    public static final String BIOME_API_CLASS = "com.prupe.mcpatcher.mal.biome.BiomeAPI";
    public static final String RANDOM_MOBS_CLASS = "com.prupe.mcpatcher.mob.MobRandomizer";
    public static final String MOB_RULE_LIST_CLASS = "com.prupe.mcpatcher.mob.MobRuleList";
    public static final String MOB_OVERLAY_CLASS = "com.prupe.mcpatcher.mob.MobOverlay";
    public static final String LINE_RENDERER_CLASS = "com.prupe.mcpatcher.mob.LineRenderer";
    public static final String COLORIZER_CLASS = "com.prupe.mcpatcher.cc.Colorizer";
    public static final String COLORIZE_WORLD_CLASS = "com.prupe.mcpatcher.cc.ColorizeWorld";
    public static final String COLORIZE_ITEM_CLASS = "com.prupe.mcpatcher.cc.ColorizeItem";
    public static final String COLORIZE_ENTITY_CLASS = "com.prupe.mcpatcher.cc.ColorizeEntity";
    public static final String COLORIZE_BLOCK_CLASS = "com.prupe.mcpatcher.cc.ColorizeBlock";
    public static final String ICOLOR_MAP_CLASS = "com.prupe.mcpatcher.cc.IColorMap";
    public static final String COLOR_MAP_BASE_CLASS = "com.prupe.mcpatcher.cc.ColorMapBase";
    public static final String COLOR_MAP_CLASS = "com.prupe.mcpatcher.cc.ColorMap";
    public static final String LIGHTMAP_CLASS = "com.prupe.mcpatcher.cc.Lightmap";
    public static final String CTM_UTILS_CLASS = "com.prupe.mcpatcher.ctm.CTMUtils";
    public static final String TILE_OVERRIDE_INTERFACE = "com.prupe.mcpatcher.ctm.ITileOverride";
    public static final String TILE_OVERRIDE_CLASS = "com.prupe.mcpatcher.ctm.TileOverride";
    public static final String TILE_OVERRIDE_IMPL_CLASS = "com.prupe.mcpatcher.ctm.TileOverrideImpl";
    public static final String GLASS_PANE_RENDERER_CLASS = "com.prupe.mcpatcher.ctm.GlassPaneRenderer";
    public static final String RENDER_PASS_CLASS = "com.prupe.mcpatcher.ctm.RenderPass";
    public static final String RENDER_PASS_API_CLASS = "com.prupe.mcpatcher.ctm.RenderPassAPI";
    public static final String SUPER_TESSELLATOR_CLASS = "com.prupe.mcpatcher.ctm.SuperTessellator";
    public static final String SKY_RENDERER_CLASS = "com.prupe.mcpatcher.sky.SkyRenderer";
    public static final String FIREWORKS_HELPER_CLASS = "com.prupe.mcpatcher.sky.FireworksHelper";
    public static final String CIT_UTILS_CLASS = "com.prupe.mcpatcher.cit.CITUtils";
    public static final String OVERRIDE_BASE_CLASS = "com.prupe.mcpatcher.cit.OverrideBase";
    public static final String ITEM_OVERRIDE_CLASS = "com.prupe.mcpatcher.cit.ItemOverride";
    public static final String ENCHANTMENT_CLASS = "com.prupe.mcpatcher.cit.Enchantment";
    public static final String ENCHANTMENT_LIST_CLASS = "com.prupe.mcpatcher.cit.EnchantmentList";
    public static final String ARMOR_OVERRIDE_CLASS = "com.prupe.mcpatcher.cit.ArmorOverride";
    public static final String POTION_REPLACER_CLASS = "com.prupe.mcpatcher.cit.PotionReplacer";
    public static final String SHADERS_CLASS = "com.prupe.mcpatcher.glsl.Shaders";
    public static final String BLANK_PNG = "mcpatcher/blank.png";

    private MCPatcherUtils() {
    }

    static File getDefaultGameDir() {
        String os = System.getProperty("os.name").toLowerCase();
        String baseDir = null;
        String subDir = ".minecraft";
        if (os.contains("win")) {
            baseDir = System.getenv("APPDATA");
        } else if (os.contains("mac")) {
            subDir = "Library/Application Support/minecraft";
        }
        if (baseDir == null) {
            baseDir = System.getProperty("user.home");
        }
        return new File(baseDir, subDir);
    }

    static boolean setGameDir(File dir) {
        minecraftDir = dir != null && dir.isDirectory() && new File(dir, "assets").isDirectory() && new File(dir, "libraries").isDirectory() && new File(dir, "versions").isDirectory() && new File(dir, "launcher_profiles.json").isFile() ? dir.getAbsoluteFile() : null;
        gameDir = minecraftDir;
        return minecraftDir != null && Config.load(minecraftDir, false);
    }

    public static File getMinecraftPath(String ... subdirs) {
        File f = minecraftDir;
        for (String s : subdirs) {
            f = new File(f, s);
        }
        return f;
    }

    public static File getGamePath(String ... subdirs) {
        File f = gameDir;
        for (String s : subdirs) {
            f = new File(f, s);
        }
        return f;
    }

    public static boolean isGame() {
        return isGame;
    }

    public static String getStringProperty(Properties properties, String key, String defaultValue) {
        if (properties == null) {
            return defaultValue;
        }
        return properties.getProperty(key, defaultValue).trim();
    }

    public static int getIntProperty(Properties properties, String key, int defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).equals("")) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static int getHexProperty(Properties properties, String key, int defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).equals("")) {
            try {
                return Integer.parseInt(value, 16);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static boolean getBooleanProperty(Properties properties, String key, boolean defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim().toLowerCase()).equals("")) {
            return Boolean.parseBoolean(value);
        }
        return defaultValue;
    }

    public static float getFloatProperty(Properties properties, String key, float defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).equals("")) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static double getDoubleProperty(Properties properties, String key, double defaultValue) {
        String value;
        if (properties != null && !(value = properties.getProperty(key, "").trim()).equals("")) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void close(ZipFile zip) {
        if (zip != null) {
            try {
                zip.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean isNullOrEmpty(String s) {
        return s == null || s.trim().isEmpty();
    }

    public static boolean isNullOrEmpty(Collection<?> c) {
        return c == null || c.isEmpty();
    }

    public static boolean isNullOrEmpty(Map<?, ?> m) {
        return m == null || m.isEmpty();
    }

    public static void setMinecraft(File gameDir, File assetsDir, String minecraftVersion, String patcherVersion) {
        boolean defaultGameDir;
        boolean defaultMCDir;
        isGame = true;
        Config.setReadOnly(true);
        if (assetsDir == null) {
            minecraftDir = MCPatcherUtils.getDefaultGameDir();
            defaultMCDir = true;
        } else {
            minecraftDir = assetsDir.getParentFile().getAbsoluteFile();
            defaultMCDir = false;
        }
        if (gameDir == null) {
            MCPatcherUtils.gameDir = minecraftDir;
            defaultGameDir = true;
        } else {
            MCPatcherUtils.gameDir = gameDir.getAbsoluteFile();
            defaultGameDir = false;
        }
        MCPatcherUtils.minecraftVersion = minecraftVersion;
        MCPatcherUtils.patcherVersion = patcherVersion;
        System.out.println();
        System.out.printf("MCPatcherUtils initialized:\n", new Object[0]);
        System.out.printf("Minecraft directory: %s%s\n", minecraftDir, defaultMCDir ? " (default)" : "");
        System.out.printf("  (assets, libraries, versions)\n", new Object[0]);
        System.out.printf("Game directory:      %s%s\n", MCPatcherUtils.gameDir, defaultGameDir ? " (default)" : "");
        System.out.printf("  (resourcepacks, saves)\n", new Object[0]);
        System.out.printf("Minecraft version:   %s\n", minecraftVersion);
        System.out.printf("MCPatcher version:   %s\n", patcherVersion);
        System.out.printf("Max heap memory:     %.1fMB\n", Float.valueOf((float)Runtime.getRuntime().maxMemory() / 1048576.0f));
        try {
            Class<?> vm = Class.forName("sun.misc.VM");
            Method method = vm.getDeclaredMethod("maxDirectMemory", new Class[0]);
            long memory = (Long)method.invoke(null, new Object[0]);
            System.out.printf("Max direct memory: %.1fMB\n", Float.valueOf((float)memory / 1048576.0f));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        Config.load(minecraftDir, true);
        System.out.printf("Launcher profile:  %s\n", Config.getInstance().getSelectedProfileName());
        System.out.println();
    }

    public static String getMinecraftVersion() {
        return minecraftVersion;
    }

    public static String getPatcherVersion() {
        return patcherVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage readImage(InputStream input) {
        BufferedImage image = null;
        if (input != null) {
            try {
                image = ImageIO.read(input);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return image;
    }

    public static Properties readProperties(InputStream input) {
        Properties properties = new Properties();
        if (MCPatcherUtils.readProperties(input, properties)) {
            return properties;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean readProperties(InputStream input, Properties properties) {
        if (input != null && properties != null) {
            try {
                properties.load(input);
                boolean bl = true;
                return bl;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return false;
    }

    public static int[] getImageRGB(BufferedImage image) {
        if (image == null) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        int[] rgb = new int[width * height];
        image.getRGB(0, 0, width, height, rgb, 0, width);
        return rgb;
    }

    public static int[] parseIntegerList(String list, int minValue, int maxValue) {
        ArrayList<Integer> tmpList = new ArrayList<Integer>();
        Pattern p = Pattern.compile("(\\d*)-(\\d*)");
        for (String token : list.replace(',', ' ').split("\\s+")) {
            try {
                if (token.matches("\\d+")) {
                    tmpList.add(Integer.parseInt(token));
                    continue;
                }
                Matcher m = p.matcher(token);
                if (!m.matches()) continue;
                String a = m.group(1);
                String b = m.group(2);
                int min = a.equals("") ? minValue : Integer.parseInt(a);
                int max = b.equals("") ? maxValue : Integer.parseInt(b);
                for (int i = min; i <= max; ++i) {
                    tmpList.add(i);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (minValue <= maxValue) {
            int i = 0;
            while (i < tmpList.size()) {
                if ((Integer)tmpList.get(i) < minValue || (Integer)tmpList.get(i) > maxValue) {
                    tmpList.remove(i);
                    continue;
                }
                ++i;
            }
        }
        int[] a = new int[tmpList.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = (Integer)tmpList.get(i);
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties getPatcherProperties() {
        if (patcherProperties == null) {
            patcherProperties = new Properties();
            InputStream input = null;
            try {
                input = MCPatcherUtils.class.getResourceAsStream("/mcpatcher.properties");
                if (input == null) {
                    System.out.printf("ERROR: could not read /%s\n", "mcpatcher.properties");
                }
                MCPatcherUtils.readProperties(input, patcherProperties);
            }
            finally {
                MCPatcherUtils.close(input);
            }
        }
        return patcherProperties;
    }
}

