/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.MCPatcherUtils;
import java.lang.reflect.Constructor;

public class MAL {
    public static <T> T newInstance(Class<T> baseClass, String apiName, String prefix) {
        String propertyName = apiName + ".MALVersion";
        int apiVersion = MCPatcherUtils.getIntProperty(MCPatcherUtils.getPatcherProperties(), propertyName, 0);
        if (apiVersion <= 0) {
            System.out.printf("ERROR: could not get %s from %s\n", propertyName, "mcpatcher.properties");
            return null;
        }
        String className = baseClass.getCanonicalName() + prefix + apiVersion;
        try {
            Class<T> apiClass = Class.forName(className).asSubclass(baseClass);
            Constructor<T> constructor = apiClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T newInstance(Class<T> baseClass, String apiName) {
        return MAL.newInstance(baseClass, apiName, "$V");
    }

    public static int getVersion(String apiName) {
        String propertyName = apiName + ".MALVersion";
        return MCPatcherUtils.getIntProperty(MCPatcherUtils.getPatcherProperties(), propertyName, 0);
    }
}

