/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import java.io.PrintStream;

public class Logger {
    public static final int LOG_NONE = -1;
    public static final int LOG_MAIN = 0;
    public static final int LOG_JAR = 0;
    public static final int LOG_GUI = 0;
    public static final int LOG_MOD = 1;
    public static final int LOG_CLASS = 2;
    public static final int LOG_METHOD = 3;
    public static final int LOG_FIELD = 3;
    public static final int LOG_CONST = 3;
    public static final int LOG_PATCH = 4;
    public static final int LOG_BYTECODE = 5;
    public static final int LOG_REGEX = 6;
    public static final int LOG_DETAIL = 7;
    private static int logLevel = 4;
    private static PrintStream out = System.out;

    static void setLogLevel(int level) {
        logLevel = level;
    }

    public static boolean isLogLevel(int level) {
        return level <= logLevel;
    }

    public static void log(int level) {
        if (Logger.isLogLevel(level)) {
            out.println();
        }
    }

    public static void log(int level, String format, Object ... params) {
        if (Logger.isLogLevel(level)) {
            StringBuilder indent = new StringBuilder(level + format.length() + 1);
            for (int i = 0; i < level; ++i) {
                indent.append(' ');
            }
            indent.append(format);
            indent.append('\n');
            out.printf(indent.toString(), params);
        }
    }

    public static void log(Throwable e) {
        e.printStackTrace(out);
    }
}

