/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.Util;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class LegacyVersionList {
    static final String VERSIONS_JSON = "mcpatcher-legacy.json";
    static final URL VERSIONS_URL = Util.newURL("https://bitbucket.org/prupe/mcpatcher-legacy/raw/master/mcpatcher-legacy.json");
    static final String DEFAULT_BASE_URL = "https://bitbucket.org/prupe/mcpatcher-legacy/downloads/";
    private int format = 1;
    private LinkedHashMap<String, Version> versions = new LinkedHashMap();

    LegacyVersionList() {
    }

    void add(Version version) {
        this.versions.put(version.getKey(), version);
    }

    List<Version> find(String api) {
        ArrayList<Version> list = new ArrayList<Version>();
        for (Map.Entry<String, Version> entry : this.versions.entrySet()) {
            if (!entry.getValue().api.equals(api)) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    static class Mod {
        String name;
        String className;
        private Boolean internal;
        private Boolean experimental;

        private Mod() {
        }

        Mod(String name, String className) {
            this.name = name;
            this.className = className;
        }

        Mod setInternal(boolean internal) {
            this.internal = internal ? Boolean.valueOf(true) : null;
            return this;
        }

        Mod setExperimental(boolean experimental) {
            this.experimental = experimental ? Boolean.valueOf(true) : null;
            return this;
        }

        boolean isInternal() {
            return this.internal != null && this.internal != false;
        }

        boolean isExperimental() {
            return this.experimental != null && this.experimental != false;
        }
    }

    static class Version {
        String id;
        String api;
        String maxMinecraftVersion;
        String libraryVersion;
        String md5;
        String baseURL;
        List<Mod> mods = new ArrayList<Mod>();

        private Version() {
        }

        Version(String id, String api, String maxMinecraftVersion, String libraryVersion) {
            this.id = id;
            this.api = api;
            this.maxMinecraftVersion = maxMinecraftVersion;
            this.libraryVersion = libraryVersion;
        }

        String getBaseURL() {
            return MCPatcherUtils.isNullOrEmpty(this.baseURL) ? LegacyVersionList.DEFAULT_BASE_URL : this.baseURL;
        }

        URL getURL() {
            return Util.newURL(this.getBaseURL() + "mcpatcher-legacy-" + this.libraryVersion + ".jar");
        }

        String getKey() {
            return this.id + "." + this.api;
        }

        String getResource() {
            return "/" + this.id + ".jar";
        }

        void add(Mod mod) {
            this.mods.add(mod);
        }
    }
}

