/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prupe.mcpatcher.MCPatcherUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;

public class JsonUtils {
    public static Gson newGson() {
        GsonBuilder builder = new GsonBuilder();
        builder.setPrettyPrinting();
        return builder.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T parseJson(File path, Class<T> cl) {
        T t;
        if (path == null || !path.isFile() || path.length() <= 0L) {
            return null;
        }
        FileInputStream input = null;
        try {
            input = new FileInputStream(path);
            t = JsonUtils.parseJson(input, cl);
        }
        catch (Throwable e) {
            T t2;
            try {
                e.printStackTrace();
                t2 = null;
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(input);
                throw throwable;
            }
            MCPatcherUtils.close(input);
            return t2;
        }
        MCPatcherUtils.close(input);
        return t;
    }

    public static <T> T parseJson(InputStream input, Class<T> cl) {
        if (input == null) {
            return null;
        }
        try {
            InputStreamReader reader = new InputStreamReader(input);
            return JsonUtils.newGson().fromJson((Reader)reader, cl);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonObject parseJson(File path) {
        JsonObject jsonObject;
        FileReader input = null;
        try {
            input = new FileReader(path);
            JsonParser parser = new JsonParser();
            jsonObject = parser.parse(input).getAsJsonObject();
        }
        catch (Throwable e) {
            JsonObject jsonObject2;
            try {
                e.printStackTrace();
                jsonObject2 = null;
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(input);
                throw throwable;
            }
            MCPatcherUtils.close(input);
            return jsonObject2;
        }
        MCPatcherUtils.close(input);
        return jsonObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeJson(JsonElement json, File path) {
        boolean bl;
        PrintWriter output = null;
        try {
            output = new PrintWriter(path);
            Gson gson = JsonUtils.newGson();
            gson.toJson(json, (Appendable)output);
            output.println();
            bl = true;
        }
        catch (Throwable e) {
            boolean bl2;
            try {
                e.printStackTrace();
                MCPatcherUtils.close(output);
                path.delete();
                bl2 = false;
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(output);
                throw throwable;
            }
            MCPatcherUtils.close(output);
            return bl2;
        }
        MCPatcherUtils.close(output);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeJson(Object object, File path) {
        boolean bl;
        PrintWriter output = null;
        try {
            output = new PrintWriter(path);
            Gson gson = JsonUtils.newGson();
            gson.toJson(object, object.getClass(), output);
            output.println();
            bl = true;
        }
        catch (Throwable e) {
            boolean bl2;
            try {
                e.printStackTrace();
                MCPatcherUtils.close(output);
                path.delete();
                bl2 = false;
            }
            catch (Throwable throwable) {
                MCPatcherUtils.close(output);
                throw throwable;
            }
            MCPatcherUtils.close(output);
            return bl2;
        }
        MCPatcherUtils.close(output);
        return bl;
    }

    public static <T extends JsonElement> T cloneJson(T json) {
        return (T)new JsonParser().parse(json.toString());
    }

    public static <T> T cloneJson(T json, Class<T> jsonClass) {
        Gson gson = JsonUtils.newGson();
        return gson.fromJson(gson.toJson(json, jsonClass), jsonClass);
    }

    private JsonUtils() {
    }
}

