/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.ClassMap;
import com.prupe.mcpatcher.MCPatcherUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

class JarClassLoader
extends ClassLoader {
    private static final String FAKE_URL_PROTOCOL = "jarjar";
    private final Map<String, byte[]> cache = new HashMap<String, byte[]>();
    private final String resourcePath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JarClassLoader(String resourcePath) throws IOException {
        this.resourcePath = resourcePath;
        InputStream input = null;
        JarInputStream jar = null;
        ByteArrayOutputStream output = null;
        try {
            JarEntry entry;
            input = this.openInputStream();
            jar = new JarInputStream(input);
            while ((entry = jar.getNextJarEntry()) != null) {
                int count;
                if (entry.isDirectory()) continue;
                String name = entry.getName();
                output = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((count = jar.read(buffer)) > 0) {
                    output.write(buffer, 0, count);
                }
                output.close();
                this.cache.put(name, output.toByteArray());
            }
        }
        catch (Throwable throwable) {
            MCPatcherUtils.close(jar);
            MCPatcherUtils.close(input);
            MCPatcherUtils.close(output);
            throw throwable;
        }
        MCPatcherUtils.close(jar);
        MCPatcherUtils.close(input);
        MCPatcherUtils.close(output);
    }

    public String toString() {
        return "JarClassLoader{" + this.resourcePath + "}";
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        String filename = ClassMap.classNameToFilename(name);
        byte[] data = this.getEntry(filename);
        if (data == null) {
            throw new ClassNotFoundException(name);
        }
        Class<?> cl = this.defineClass(name, data, 0, data.length);
        this.resolveClass(cl);
        return cl;
    }

    @Override
    protected URL findResource(final String name) {
        try {
            return new URL(FAKE_URL_PROTOCOL, this.resourcePath, 0, "/" + name, new URLStreamHandler(){

                @Override
                protected URLConnection openConnection(URL u) throws IOException {
                    return new URLConnection(u){

                        @Override
                        public void connect() throws IOException {
                        }

                        @Override
                        public InputStream getInputStream() throws IOException {
                            byte[] data = JarClassLoader.this.getEntry(name);
                            if (data == null) {
                                throw new FileNotFoundException(name);
                            }
                            return new ByteArrayInputStream(data);
                        }
                    };
                }
            });
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private InputStream openInputStream() throws IOException {
        InputStream input = this.getParent().getResourceAsStream(this.resourcePath);
        if (input == null && (input = this.getParent().getResourceAsStream(this.resourcePath.replaceFirst("^/", ""))) == null) {
            throw new FileNotFoundException(this.resourcePath);
        }
        return input;
    }

    private byte[] getEntry(String filename) {
        return this.cache.get(filename);
    }
}

