/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.UserInterface;
import com.prupe.mcpatcher.Util;
import com.prupe.mcpatcher.launcher.version.Library;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.Adler32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

class ForgeAdapter
extends Mod {
    static final String FORGE_LIB_NAME = "minecraftforge";
    private static final int FORGE_MIN_VERSION = 804;
    private static final String FORGE_MIN_VERSION_STR = "9.10.0.804";
    private static final String GDIFF_CLASS = "cpw.mods.fml.repackage.com.nothome.delta.GDiffPatcher";
    private static final String GDIFF_PATCH_METHOD = "patch";
    private static final String LZMA_PACKAGE = "lzma";
    private static final String LZMA_NAME = "lzma";
    private static final String LZMA_VERSION = "0.0.1";
    private static final String LZMA_MAVEN = "lzma:lzma:0.0.1";
    private static final String LZMA_CLASS = "LZMA.LzmaInputStream";
    private static final String BINPATCHES_PACK = "binpatches.pack.lzma";
    private static final String BINPATCH_PREFIX = "binpatch/client/";
    private static final String BINPATCH_SUFFIX = ".binpatch";
    private final File mcLibDir;
    private final File forgeJarPath;
    private final Map<String, Binpatch> patches = new HashMap<String, Binpatch>();
    private int buildNumber;
    private Constructor<?> gdiffConstructor1;
    private Constructor<?> gdiffConstructor2;
    private Method gdiffPatchMethod;
    private Constructor<? extends InputStream> lzmaConstructor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ForgeAdapter(UserInterface ui, Library forgeLibrary) throws Exception {
        this.mcLibDir = MCPatcherUtils.getMinecraftPath("libraries");
        this.forgeJarPath = forgeLibrary.getPath(this.mcLibDir);
        this.name = "Minecraft Forge";
        this.author = "Minecraft Forge team";
        this.description = "Minecraft Forge";
        this.version = forgeLibrary.getVersion();
        this.website = "http://minecraftforge.net/";
        this.clearDependencies();
        if (!FORGE_LIB_NAME.equalsIgnoreCase(forgeLibrary.getName())) {
            throw new IOException("Invalid filename " + this.forgeJarPath.getName());
        }
        String temp = this.version.replaceAll(".*[^0-9](\\d+)$", "$1");
        if (!MCPatcherUtils.isNullOrEmpty(temp)) {
            try {
                this.buildNumber = Integer.parseInt(temp);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        if (this.buildNumber != 0 && this.buildNumber < 804) {
            this.addError("Requires Forge 9.10.0.804 or newer");
            return;
        }
        ui.setStatusText("Analyzing %s...", this.forgeJarPath.getName());
        ui.updateProgress(0, 3);
        this.setupClassLoader();
        ZipFile forgeZip = null;
        try {
            ui.updateProgress(1, 3);
            forgeZip = new ZipFile(this.forgeJarPath);
            ui.updateProgress(2, 3);
            this.loadBinPatches(forgeZip, BINPATCHES_PACK);
            ui.updateProgress(3, 3);
        }
        catch (Throwable throwable) {
            MCPatcherUtils.close(forgeZip);
            ui.updateProgress(0, 0);
            ui.setStatusText("", new Object[0]);
            throw throwable;
        }
        MCPatcherUtils.close(forgeZip);
        ui.updateProgress(0, 0);
        ui.setStatusText("", new Object[0]);
        this.description = String.format("%d classes modified", this.patches.size());
    }

    @Override
    public String[] getLoggingCategories() {
        return null;
    }

    @Override
    public InputStream openFile(String name) throws IOException {
        Binpatch binpatch = this.patches.get(name = name.replaceFirst("^/", ""));
        if (binpatch == null) {
            throw new IOException("No patch for " + name);
        }
        byte[] input = binpatch.getInput(MCPatcher.minecraft.getInputJar());
        byte[] output = binpatch.apply(input);
        ByteArrayOutputStream tmp = new ByteArrayOutputStream();
        tmp.write(output);
        return new ByteArrayInputStream(tmp.toByteArray());
    }

    @Override
    void addExtraJavaArguments(List<String> cmdLine) {
        cmdLine.add("-Dfml.ignorePatchDiscrepancies=true");
        cmdLine.add("-Dfml.ignoreInvalidMinecraftCertificates=true");
    }

    private void setupClassLoader() throws Exception {
        Library lzmaLib = new Library(LZMA_MAVEN, null);
        lzmaLib.fetch(this.mcLibDir);
        URLClassLoader classLoader = URLClassLoader.newInstance(new URL[]{lzmaLib.getPath(this.mcLibDir).toURI().toURL(), this.forgeJarPath.toURI().toURL()}, this.getClass().getClassLoader());
        Class<?> gdiffClass = classLoader.loadClass(GDIFF_CLASS);
        try {
            this.gdiffConstructor1 = gdiffClass.getDeclaredConstructor(new Class[0]);
            this.gdiffPatchMethod = gdiffClass.getDeclaredMethod(GDIFF_PATCH_METHOD, byte[].class, InputStream.class, OutputStream.class);
        }
        catch (NoSuchMethodException e) {
            this.gdiffConstructor2 = gdiffClass.getDeclaredConstructor(byte[].class, InputStream.class, OutputStream.class);
        }
        Class<InputStream> lzmaClass = classLoader.loadClass(LZMA_CLASS).asSubclass(InputStream.class);
        this.lzmaConstructor = lzmaClass.getConstructor(InputStream.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBinPatches(ZipFile zip, String name) throws Exception {
        ZipEntry entry = zip.getEntry(name);
        if (entry == null) {
            throw new IOException("Could not load " + name + " from " + this.forgeJarPath.getName());
        }
        InputStream raw = null;
        InputStream lzma = null;
        ZipInputStream zipStream = null;
        JarOutputStream jar = null;
        try {
            raw = zip.getInputStream(entry);
            lzma = this.lzmaConstructor.newInstance(raw);
            ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
            jar = new JarOutputStream(byteOutput);
            Pack200.Unpacker pack = Pack200.newUnpacker();
            pack.unpack(lzma, jar);
            jar.close();
            ByteArrayInputStream byteInput = new ByteArrayInputStream(byteOutput.toByteArray());
            zipStream = new ZipInputStream(byteInput);
            while ((entry = zipStream.getNextEntry()) != null) {
                if (entry.isDirectory() || !(name = entry.getName()).startsWith(BINPATCH_PREFIX) || !name.endsWith(BINPATCH_SUFFIX)) continue;
                Binpatch binpatch = new Binpatch(zipStream);
                this.addClassFile(binpatch.obfClass);
                this.patches.put(binpatch.filename, binpatch);
            }
        }
        catch (Throwable throwable) {
            MCPatcherUtils.close(jar);
            MCPatcherUtils.close(zipStream);
            MCPatcherUtils.close(lzma);
            MCPatcherUtils.close(raw);
            throw throwable;
        }
        MCPatcherUtils.close(jar);
        MCPatcherUtils.close(zipStream);
        MCPatcherUtils.close(lzma);
        MCPatcherUtils.close(raw);
    }

    private class Binpatch {
        final String filename;
        final String obfClass;
        final String deobfClass;
        final boolean hasInput;
        final int checksum;
        final byte[] patchData;

        Binpatch(InputStream input) throws IOException {
            int actualLen;
            int count;
            DataInputStream data = new DataInputStream(input);
            this.filename = data.readUTF() + ".class";
            this.obfClass = data.readUTF();
            this.deobfClass = data.readUTF();
            this.hasInput = data.readBoolean();
            this.checksum = this.hasInput ? data.readInt() : 0;
            int expLen = data.readInt();
            this.patchData = new byte[expLen];
            for (actualLen = 0; actualLen < expLen && (count = data.read(this.patchData, actualLen, expLen - actualLen)) > 0; actualLen += count) {
            }
            if (actualLen != expLen) {
                throw new IOException(String.format("Patch %s: EOF at %d/%d bytes", this.filename, actualLen, expLen));
            }
        }

        byte[] getInput(JarFile jar) throws IOException {
            if (this.hasInput) {
                JarEntry entry = jar.getJarEntry(this.filename);
                if (entry == null) {
                    throw new IOException(String.format("Patch %s: input file is missing", this.filename));
                }
                InputStream inputStream = jar.getInputStream(entry);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                Util.copyStream(inputStream, outputStream);
                MCPatcherUtils.close(inputStream);
                MCPatcherUtils.close(outputStream);
                byte[] output = outputStream.toByteArray();
                Adler32 adler = new Adler32();
                adler.update(output);
                int actual = (int)adler.getValue();
                if (actual != this.checksum) {
                    throw new IOException(String.format("Patch %s: invalid checksum: expected=%08x, actual=%08x", this.filename, this.checksum, actual));
                }
                return output;
            }
            return new byte[0];
        }

        private byte[] apply(byte[] input) throws IOException {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ByteArrayInputStream diff = new ByteArrayInputStream(this.patchData);
            try {
                if (ForgeAdapter.this.gdiffConstructor1 != null) {
                    Object patcher = ForgeAdapter.this.gdiffConstructor1.newInstance(new Object[0]);
                    ForgeAdapter.this.gdiffPatchMethod.invoke(patcher, input, diff, output);
                } else {
                    ForgeAdapter.this.gdiffConstructor2.newInstance(input, diff, output);
                }
                return output.toByteArray();
            }
            catch (Throwable e) {
                throw new IOException(e);
            }
        }
    }
}

