/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.Mod;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ExternalMod
extends Mod {
    final ZipFile zipFile;
    final Map<String, String> fileMap = new LinkedHashMap<String, String>();
    private String defaultDescription;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExternalMod(ZipFile zipFile, Map<String, String> fileMap) {
        this.dependencies.clear();
        this.zipFile = zipFile;
        this.setFileMap(fileMap);
        this.name = new File(zipFile.getName()).getName().replaceFirst("\\.[^.]+$", "");
        Properties properties = new Properties();
        InputStream is = null;
        try {
            ZipEntry entry = zipFile.getEntry("mod.properties");
            if (entry != null) {
                is = zipFile.getInputStream(entry);
                properties.load(is);
                String value = properties.getProperty("name", "").trim();
                if (!value.equals("")) {
                    this.name = value;
                }
                this.author = properties.getProperty("author", "").trim();
                this.website = properties.getProperty("website", "").trim();
                this.version = properties.getProperty("version", "").trim();
                this.description = properties.getProperty("description", "").trim();
                for (String m : properties.getProperty("dependencies", "").split(",")) {
                    if ((m = m.trim()).equals("")) continue;
                    this.addDependency(m);
                }
                for (String m : properties.getProperty("conflicts", "").split(",")) {
                    if ((m = m.trim()).equals("")) continue;
                    this.addConflict(m);
                }
                String mcVersion = properties.getProperty("minecraft.version", "").trim();
                if (!mcVersion.equals("") && !mcVersion.equals(MCPatcher.minecraft.getVersion().getVersionString())) {
                    this.addError("Requires Minecraft " + mcVersion);
                }
            }
        }
        catch (IOException e) {
        }
        finally {
            MCPatcherUtils.close(is);
        }
    }

    static boolean isValidPath(File path) {
        return path.getName().toLowerCase().endsWith(".zip");
    }

    static String getFileTypePattern() {
        return "*.zip";
    }

    void setFileMap(Map<String, String> newFileMap) {
        this.fileMap.clear();
        this.fileMap.putAll(newFileMap);
        this.filesToAdd.clear();
        this.filesToAdd.addAll(this.fileMap.keySet());
        int numFiles = this.fileMap.size();
        this.defaultDescription = String.format("%d file%s to add or replace.", numFiles, numFiles == 1 ? "" : "s");
    }

    @Override
    public String getDescription() {
        return this.description == null || this.description.equals("") ? this.defaultDescription : this.description;
    }

    @Override
    public String[] getLoggingCategories() {
        return null;
    }

    @Override
    public InputStream openFile(String filename) throws IOException {
        String path = this.fileMap.get(filename.replaceFirst("^/", ""));
        if (path == null) {
            return null;
        }
        return this.zipFile.getInputStream(new ZipEntry(path));
    }

    @Override
    public void close() {
        MCPatcherUtils.close(this.zipFile);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

