/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.prupe.mcpatcher.ProfileManager;
import java.awt.Component;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class DeleteProfileDialog {
    private JLabel textLabel;
    private JPanel panel;
    private JPanel checkBoxPanel;
    private final List<String> versions;
    private final List<JCheckBox> checkBoxes;
    private final ProfileManager profileManager;

    DeleteProfileDialog(ProfileManager profileManager) {
        this.$$$setupUI$$$();
        this.versions = new ArrayList<String>();
        this.checkBoxes = new ArrayList<JCheckBox>();
        this.profileManager = profileManager;
    }

    JPanel getPanel() {
        return this.panel;
    }

    void setProfile(String profileName, List<String> versions) {
        this.versions.clear();
        this.checkBoxes.clear();
        this.checkBoxPanel.removeAll();
        this.checkBoxPanel.setLayout(new BoxLayout(this.checkBoxPanel, 1));
        this.checkBoxPanel.add(new JLabel("Also remove the following version directories:"));
        for (String s : versions) {
            File dir = this.profileManager.getLocalVersionPath(s);
            if (dir == null || !dir.isDirectory()) continue;
            this.versions.add(s);
            JCheckBox box = new JCheckBox(dir.toString(), false);
            this.checkBoxes.add(box);
            this.checkBoxPanel.add(box);
        }
        this.textLabel.setText("Delete saved profile \"" + profileName + "\"?");
        if (this.checkBoxes.isEmpty()) {
            this.checkBoxPanel.setVisible(false);
        } else {
            this.checkBoxPanel.setVisible(true);
        }
    }

    void deleteInstallations() {
        for (int i = 0; i < this.checkBoxes.size(); ++i) {
            if (!this.checkBoxes.get(i).isSelected()) continue;
            this.profileManager.deleteLocalVersion(this.versions.get(i));
        }
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JLabel jLabel;
        JPanel jPanel2;
        this.panel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.textLabel = jLabel = new JLabel();
        jLabel.setText("Delete profile?");
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.checkBoxPanel = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

