/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.ClassRef;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Util;
import java.util.ArrayList;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Mnemonic;

class ConstPoolUtils {
    static final byte[] CONSTANT_OPCODES = new byte[]{18, 19, 20};
    static final byte[] CLASSREF_OPCODES = new byte[]{-69, -67, -64, -63, -59};
    static final byte[] FIELDREF_OPCODES = new byte[]{-76, -78, -75, -77};
    static final byte[] METHODREF_OPCODES = new byte[]{-74, -72, -73};
    static final byte[] INTERFACEMETHODREF_OPCODES = new byte[]{-71};
    static final String DESCRIPTOR_TYPES = "VZBCSIJFD";
    static final String DESCRIPTOR_CHARS = "VZBCSIJFD()<>[";
    private static final byte[] NOT_FOUND = null;
    private static final int MAX_LDC_INDEX = 255;

    ConstPoolUtils() {
    }

    static int getTag(Object o) {
        if (o instanceof Float) {
            return 4;
        }
        if (o instanceof Double) {
            return 6;
        }
        if (o instanceof Integer) {
            return 3;
        }
        if (o instanceof Long) {
            return 5;
        }
        if (o instanceof String) {
            return 8;
        }
        if (o instanceof MethodRef) {
            return 10;
        }
        if (o instanceof InterfaceMethodRef) {
            return 11;
        }
        if (o instanceof FieldRef) {
            return 9;
        }
        if (o instanceof ClassRef) {
            return 7;
        }
        throw new IllegalArgumentException("Unhandled type: " + o.getClass().getName());
    }

    private static int addToPool(ConstPool cp, Object o) {
        if (o instanceof Float) {
            return cp.addFloatInfo(((Float)o).floatValue());
        }
        if (o instanceof Double) {
            return cp.addDoubleInfo((Double)o);
        }
        if (o instanceof Integer) {
            return cp.addIntegerInfo((Integer)o);
        }
        if (o instanceof Long) {
            return cp.addLongInfo((Long)o);
        }
        if (o instanceof String) {
            return cp.addStringInfo((String)o);
        }
        if (o instanceof MethodRef) {
            MethodRef mr = (MethodRef)o;
            int ci = ConstPoolUtils.findOrAdd(cp, new ClassRef(mr.getClassName().replaceAll("\\.", "/")));
            return cp.addMethodrefInfo(ci, mr.getName(), mr.getType());
        }
        if (o instanceof InterfaceMethodRef) {
            InterfaceMethodRef imr = (InterfaceMethodRef)o;
            int ci = ConstPoolUtils.findOrAdd(cp, new ClassRef(imr.getClassName().replaceAll("\\.", "/")));
            return cp.addInterfaceMethodrefInfo(ci, imr.getName(), imr.getType());
        }
        if (o instanceof FieldRef) {
            FieldRef fr = (FieldRef)o;
            int ci = ConstPoolUtils.findOrAdd(cp, new ClassRef(fr.getClassName().replaceAll("\\.", "/")));
            return cp.addFieldrefInfo(ci, fr.getName(), fr.getType());
        }
        if (o instanceof ClassRef) {
            return cp.addClassInfo(((ClassRef)o).getClassName());
        }
        throw new IllegalArgumentException("Unhandled type: " + o.getClass().getName());
    }

    static boolean checkEqual(ConstPool cp, int index, Object o) {
        if (o instanceof Float) {
            return cp.getFloatInfo(index) == ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return cp.getDoubleInfo(index) == ((Double)o).doubleValue();
        }
        if (o instanceof Integer) {
            return cp.getIntegerInfo(index) == ((Integer)o).intValue();
        }
        if (o instanceof Long) {
            return cp.getLongInfo(index) == ((Long)o).longValue();
        }
        if (o instanceof String) {
            return o.equals(cp.getStringInfo(index));
        }
        if (o instanceof JavaRef) {
            return ((JavaRef)o).checkEqual(cp, index);
        }
        throw new IllegalArgumentException("Unhandled type: " + o.getClass().getName());
    }

    static int find(ConstPool cp, Object value) {
        return ConstPoolUtils.find(cp, value, ConstPoolUtils.getTag(value));
    }

    static int find(ConstPool cp, Object value, int tag) {
        for (int i = 1; i < cp.getSize(); ++i) {
            if (cp.getTag(i) != tag || !ConstPoolUtils.checkEqual(cp, i, value)) continue;
            return i;
        }
        return -1;
    }

    private static int findOrAdd(ConstPool cp, Object value) {
        int index = ConstPoolUtils.find(cp, value);
        if (index < 0) {
            index = ConstPoolUtils.addToPool(cp, value);
        }
        return index;
    }

    private static byte[] getLoad(int op, int i) {
        int mop = op;
        if (i > 255 && mop == 18) {
            mop = 19;
        }
        if (mop == 18) {
            return new byte[]{(byte)mop, Util.b(i, 0)};
        }
        return new byte[]{(byte)mop, Util.b(i, 1), Util.b(i, 0)};
    }

    private static Object getLoadExpr(int op, int i) {
        int mop = op;
        if (i > 255 && mop == 18) {
            mop = 19;
        }
        if (mop == 18) {
            return BinaryRegex.or(BinaryRegex.build(18, Util.b(i, 0)), BinaryRegex.build(19, Util.b(i, 1), Util.b(i, 0)));
        }
        return new byte[]{(byte)mop, Util.b(i, 1), Util.b(i, 0)};
    }

    static Object push(ConstPool cp, Object value, boolean add) {
        int index;
        if (value instanceof Boolean) {
            if (((Boolean)value).booleanValue()) {
                return new byte[]{4};
            }
            return new byte[]{3};
        }
        if (value instanceof Byte) {
            return ConstPoolUtils.push(cp, (Byte)value, add);
        }
        if (value instanceof Character) {
            return ConstPoolUtils.push(cp, ((Character)value).charValue(), add);
        }
        if (value instanceof Integer) {
            int i = (Integer)value;
            switch (i) {
                case -1: {
                    return new byte[]{2};
                }
                case 0: {
                    return new byte[]{3};
                }
                case 1: {
                    return new byte[]{4};
                }
                case 2: {
                    return new byte[]{5};
                }
                case 3: {
                    return new byte[]{6};
                }
                case 4: {
                    return new byte[]{7};
                }
                case 5: {
                    return new byte[]{8};
                }
            }
            if (i >= -128 && i <= 127) {
                return new byte[]{16, (byte)i};
            }
            if (i >= Short.MIN_VALUE && i <= Short.MAX_VALUE) {
                return new byte[]{17, Util.b(i, 1), Util.b(i, 0)};
            }
        } else if (value instanceof Long) {
            long l = (Long)value;
            if (l == 0L) {
                return new byte[]{9};
            }
            if (l == 1L) {
                return new byte[]{10};
            }
        } else if (value instanceof Float) {
            float f = ((Float)value).floatValue();
            if (f == 0.0f) {
                return new byte[]{11};
            }
            if (f == 1.0f) {
                return new byte[]{12};
            }
            if (f == 2.0f) {
                return new byte[]{13};
            }
        } else if (value instanceof Double) {
            double d = (Double)value;
            if (d == 0.0) {
                return new byte[]{14};
            }
            if (d == 1.0) {
                return new byte[]{15};
            }
        }
        int n = index = add ? ConstPoolUtils.findOrAdd(cp, value) : ConstPoolUtils.find(cp, value);
        if (index >= 0) {
            int op;
            int n2 = op = value instanceof Double || value instanceof Long ? 20 : 18;
            if (add) {
                return ConstPoolUtils.getLoad(op, index);
            }
            return ConstPoolUtils.getLoadExpr(op, index);
        }
        return NOT_FOUND;
    }

    static byte[] reference(ConstPool cp, Object value, boolean add) {
        int index;
        int n = index = add ? ConstPoolUtils.findOrAdd(cp, value) : ConstPoolUtils.find(cp, value);
        if (index < 0) {
            return NOT_FOUND;
        }
        return Util.marshal16(index);
    }

    static void matchOpcodeToRefType(int opcode, Object value) {
        if (!Util.contains(CONSTANT_OPCODES, opcode &= 0xFF)) {
            if (Util.contains(FIELDREF_OPCODES, opcode)) {
                if (!(value instanceof FieldRef)) {
                    throw new IllegalArgumentException(Mnemonic.OPCODE[opcode] + " requires a FieldRef object");
                }
            } else if (Util.contains(CLASSREF_OPCODES, opcode)) {
                if (!(value instanceof ClassRef)) {
                    throw new IllegalArgumentException(Mnemonic.OPCODE[opcode] + " requires a ClassRef object");
                }
            } else if (Util.contains(METHODREF_OPCODES, opcode)) {
                if (!(value instanceof MethodRef)) {
                    throw new IllegalArgumentException(Mnemonic.OPCODE[opcode] + " requires a MethodRef object");
                }
            } else if (Util.contains(INTERFACEMETHODREF_OPCODES, opcode) && !(value instanceof InterfaceMethodRef)) {
                throw new IllegalArgumentException(Mnemonic.OPCODE[opcode] + " requires an InterfaceMethodRef object");
            }
        }
    }

    static void matchConstPoolTagToRefType(int tag, Object value) {
        switch (tag) {
            case 9: {
                if (value instanceof FieldRef) break;
                throw new IllegalArgumentException("CONST_Fieldref requires a FieldRef object");
            }
            case 10: {
                if (value instanceof MethodRef) break;
                throw new IllegalArgumentException("CONST_Methodref requires a MethodRef object");
            }
            case 11: {
                if (value instanceof InterfaceMethodRef) break;
                throw new IllegalArgumentException("CONST_InterfaceMethodref requires an InterfaceMethodRef object");
            }
            case 7: {
                if (value instanceof ClassRef) break;
                throw new IllegalArgumentException("CONST_Class requires a ClassRef object");
            }
        }
    }

    static JavaRef getRefForIndex(ConstPool constPool, int index) {
        int tag = constPool.getTag(index);
        switch (tag) {
            case 9: {
                return new FieldRef(constPool.getFieldrefClassName(index), constPool.getFieldrefName(index), constPool.getFieldrefType(index));
            }
            case 10: {
                return new MethodRef(constPool.getMethodrefClassName(index), constPool.getMethodrefName(index), constPool.getMethodrefType(index));
            }
            case 11: {
                return new InterfaceMethodRef(constPool.getInterfaceMethodrefClassName(index), constPool.getInterfaceMethodrefName(index), constPool.getInterfaceMethodrefType(index));
            }
            case 7: {
                return new ClassRef(constPool.getClassInfo(index));
            }
        }
        throw new IllegalArgumentException(String.format("cannot create JavaRef for constPool[%d] tag %d", index, tag));
    }

    static byte[] reference(ConstPool cp, int opcode, Object value, boolean add) {
        int index;
        int n = index = add ? ConstPoolUtils.findOrAdd(cp, value) : ConstPoolUtils.find(cp, value);
        if (index < 0) {
            return NOT_FOUND;
        }
        ConstPoolUtils.matchOpcodeToRefType(opcode, value);
        if (Util.contains(CONSTANT_OPCODES, opcode)) {
            return ConstPoolUtils.getLoad(opcode, index);
        }
        if (Util.contains(INTERFACEMETHODREF_OPCODES, opcode) && value instanceof InterfaceMethodRef) {
            int numArgs = 0;
            for (String s : ConstPoolUtils.parseDescriptor(((InterfaceMethodRef)value).getType())) {
                numArgs += s.equals("D") || s.equals("J") ? 2 : 1;
            }
            return new byte[]{(byte)opcode, Util.b(index, 1), Util.b(index, 0), (byte)numArgs, 0};
        }
        return new byte[]{(byte)opcode, Util.b(index, 1), Util.b(index, 0)};
    }

    static void checkTypeDescriptorSyntax(String descriptor) {
        for (int i = 0; i < descriptor.length(); ++i) {
            char c = descriptor.charAt(i);
            if (DESCRIPTOR_CHARS.indexOf(c) >= 0) continue;
            if (c == 'L') {
                int j = descriptor.indexOf(59, i);
                if (j < 0) {
                    throw new IllegalArgumentException("invalid type descriptor \"" + descriptor + "\": missing semicolon @" + i);
                }
                i = j;
                continue;
            }
            throw new IllegalArgumentException("invalid type descriptor \"" + descriptor + "\": bad type @" + i);
        }
    }

    static ArrayList<String> parseDescriptor(String descriptor) {
        ConstPoolUtils.checkTypeDescriptorSyntax(descriptor);
        ArrayList<String> types = new ArrayList<String>();
        descriptor = descriptor.replaceAll("[()]", "");
        int len = descriptor.length();
        int i = 0;
        while (i < len) {
            char c;
            int j;
            for (j = i; j < len && DESCRIPTOR_TYPES.indexOf(c = descriptor.charAt(j)) < 0; ++j) {
                if (c != 'L') continue;
                while (descriptor.charAt(j) != ';') {
                    ++j;
                }
                break;
            }
            types.add(descriptor.substring(i, j + 1));
            i = j + 1;
        }
        return types;
    }
}

