/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.prupe.mcpatcher.JsonUtils;
import com.prupe.mcpatcher.MCPatcherUtils;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class Config {
    private static Config instance = new Config();
    private static File jsonFile;
    private static boolean readOnly;
    public static final String MCPATCHER_PROPERTIES = "mcpatcher.properties";
    public static final String MCPATCHER_JSON = "mcpatcher.json";
    public static final String LAUNCHER_JSON = "launcher_profiles.json";
    public static final String VERSIONS_JSON = "versions.json";
    static final String TAG_MINECRAFT_VERSION = "minecraftVersion";
    static final String TAG_PATCHER_VERSION = "patcherVersion";
    static final String TAG_PRE_PATCH_STATE = "prePatchState";
    static final String TAG_MODIFIED_CLASSES = "modifiedClasses";
    static final String TAG_ADDED_CLASSES = "addedClasses";
    static final String VAL_BUILTIN = "builtIn";
    static final String VAL_EXTERNAL_ZIP = "externalZip";
    static final String VAL_EXTERNAL_JAR = "externalJar";
    static final String TAG_MAL_VERSION = ".MALVersion";
    private static final String TAG_SELECTED_PROFILE = "selectedProfile";
    public static final String MCPATCHER_PROFILE_NAME = "MCPatcher";
    private static final int VAL_FORMAT_CURRENT = 1;
    private static final int VAL_FORMAT_MIN = 1;
    private static final int VAL_FORMAT_MAX = 1;
    transient String selectedProfile = "MCPatcher";
    int format = 1;
    String patcherVersion;
    boolean betaWarningShown;
    boolean selectPatchedProfile = true;
    boolean fetchRemoteVersionList = true;
    boolean extraProfiling;
    String lastModDirectory;
    int floodMessageLimit = 1000;
    LinkedHashMap<String, String> logging = new LinkedHashMap();
    LinkedHashMap<String, ProfileEntry> profiles = new LinkedHashMap();

    static boolean load(File minecraftDir, boolean isGame) {
        jsonFile = new File(minecraftDir, MCPATCHER_JSON);
        instance = JsonUtils.parseJson(jsonFile, Config.class);
        if (instance == null || Config.instance.format <= 0) {
            instance = new Config();
            if (isGame) {
                System.out.printf("WARNING: configuration file %s not found, using defaults\n", jsonFile);
            }
            Config.save();
        } else if (Config.instance.format < 1) {
            Config.instance.format = 1;
            Config.save();
        } else if (Config.instance.format > 1) {
            Config.setReadOnly(true);
        }
        String profile = Config.getSelectedLauncherProfile(minecraftDir);
        if (MCPatcherUtils.isNullOrEmpty(profile)) {
            if (isGame) {
                System.out.printf("WARNING: could not determine selected profile, defaulting to %s\n", MCPATCHER_PROFILE_NAME);
            }
            profile = MCPATCHER_PROFILE_NAME;
        } else if (!Config.instance.profiles.containsKey(profile) && isGame) {
            System.out.printf("WARNING: selected profile '%s' not found, using defaults\n", profile);
        }
        Config.instance.selectedProfile = profile;
        return true;
    }

    static boolean save() {
        boolean success = false;
        if (jsonFile != null && !readOnly) {
            JsonUtils.writeJson(instance, jsonFile);
        }
        return success;
    }

    private static String getSelectedLauncherProfile(File minecraftDir) {
        JsonElement element;
        File path = new File(minecraftDir, LAUNCHER_JSON);
        JsonObject json = JsonUtils.parseJson(path);
        if (json != null && (element = json.get(TAG_SELECTED_PROFILE)) != null && element.isJsonPrimitive()) {
            return element.getAsString();
        }
        return null;
    }

    public static Config getInstance() {
        return instance;
    }

    public static void setReadOnly(boolean readOnly) {
        Config.readOnly = readOnly;
    }

    static Level getLogLevel(String category) {
        Level level = Level.INFO;
        String value = Config.instance.logging.get(category);
        if (value != null) {
            try {
                level = Level.parse(value.trim().toUpperCase());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        Config.setLogLevel(category, level);
        return level;
    }

    static void setLogLevel(String category, Level level) {
        Config.instance.logging.put(category, level.toString().toUpperCase());
    }

    public static String getString(String mod, String tag, Object defaultValue) {
        LinkedHashMap<String, String> modConfig = instance.getModConfig(mod);
        String value = modConfig.get(tag);
        if (value == null) {
            modConfig.put(tag, defaultValue.toString());
            return defaultValue.toString();
        }
        return value;
    }

    public static int getInt(String mod, String tag, int defaultValue) {
        int value;
        try {
            value = Integer.parseInt(Config.getString(mod, tag, defaultValue));
        }
        catch (NumberFormatException e) {
            value = defaultValue;
        }
        return value;
    }

    public static boolean getBoolean(String mod, String tag, boolean defaultValue) {
        String value = Config.getString(mod, tag, defaultValue).toLowerCase();
        if (value.equals("false")) {
            return false;
        }
        if (value.equals("true")) {
            return true;
        }
        return defaultValue;
    }

    public static void set(String mod, String tag, Object value) {
        if (value == null) {
            Config.remove(mod, tag);
            return;
        }
        instance.getModConfig(mod).put(tag, value.toString());
    }

    public static void remove(String mod, String tag) {
        instance.getModConfig(mod).remove(tag);
    }

    String getSelectedProfileName() {
        if (MCPatcherUtils.isNullOrEmpty(this.selectedProfile)) {
            this.selectedProfile = MCPATCHER_PROFILE_NAME;
        }
        return this.selectedProfile;
    }

    ProfileEntry getSelectedProfile() {
        ProfileEntry profile = this.profiles.get(this.getSelectedProfileName());
        if (profile == null) {
            profile = new ProfileEntry();
            this.profiles.put(this.selectedProfile, profile);
        }
        return profile;
    }

    VersionEntry getSelectedVersion() {
        ProfileEntry profile = this.getSelectedProfile();
        VersionEntry version = profile.versions.get(profile.version);
        if (version == null) {
            version = new VersionEntry();
            profile.versions.put(profile.version, version);
        }
        return version;
    }

    ModEntry getModEntry(String mod) {
        return this.getSelectedVersion().mods.get(mod);
    }

    Collection<ModEntry> getModEntries() {
        return this.getSelectedVersion().mods.values();
    }

    private LinkedHashMap<String, String> getModConfig(String mod) {
        return this.getSelectedProfile().getModConfig(mod);
    }

    void removeMod(String mod) {
        this.getSelectedProfile().config.remove(mod);
        this.getSelectedVersion().mods.remove(mod);
    }

    void removeProfile(String name) {
        if (!name.equals(this.selectedProfile)) {
            this.profiles.remove(name);
        }
    }

    void removeVersion(String name) {
        if (!name.equals(this.getSelectedProfile().version)) {
            this.getSelectedProfile().versions.remove(name);
        }
    }

    Map<String, String> getPatchedVersionMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (ProfileEntry profile : this.profiles.values()) {
            profile.versions.remove(null);
            profile.versions.remove("");
            for (Map.Entry<String, VersionEntry> entry : profile.versions.entrySet()) {
                String patchedVersion = entry.getKey();
                String unpatchedVersion = entry.getValue().original;
                map.put(patchedVersion, unpatchedVersion);
            }
        }
        return map;
    }

    static class FileEntry {
        String from;
        String to;

        private FileEntry() {
        }

        FileEntry(String from, String to) {
            this.from = from;
            this.to = to;
        }
    }

    static class ModEntry {
        String type;
        boolean enabled;
        String path;
        String className;
        List<FileEntry> files;

        ModEntry() {
        }
    }

    static class VersionEntry {
        String original;
        LinkedHashMap<String, ModEntry> mods = new LinkedHashMap();

        VersionEntry() {
        }
    }

    static class ProfileEntry {
        String original;
        String version;
        LinkedHashMap<String, LinkedHashMap<String, String>> config = new LinkedHashMap();
        LinkedHashMap<String, VersionEntry> versions = new LinkedHashMap();

        ProfileEntry() {
        }

        private LinkedHashMap<String, String> getModConfig(String mod) {
            LinkedHashMap<String, String> map = this.config.get(mod);
            if (map == null) {
                map = new LinkedHashMap();
                this.config.put(mod, map);
            }
            return map;
        }
    }
}

