/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.BytecodeSignature;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassPatch;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.Mnemonic;

public abstract class BytecodePatch
extends ClassPatch {
    private final Set<MethodRef> targetMethods = new HashSet<MethodRef>();
    private final Set<MethodRef> skipMethods = new HashSet<MethodRef>();
    boolean constructorOnly;
    boolean staticInitializerOnly;
    private final List<BytecodeSignature> preMatchSignatures = new ArrayList<BytecodeSignature>();
    private boolean insertBefore;
    private boolean insertAfter;
    int labelOffset;
    protected BytecodeMatcher matcher;

    public BytecodePatch(ClassMod classMod) {
        super(classMod);
    }

    public BytecodePatch targetMethod(MethodRef ... targetMethods) {
        Collections.addAll(this.targetMethods, targetMethods);
        return this;
    }

    public BytecodePatch skipMethod(MethodRef ... skipMethods) {
        Collections.addAll(this.skipMethods, skipMethods);
        return this;
    }

    public BytecodePatch matchConstructorOnly(boolean only) {
        this.constructorOnly = only;
        return this;
    }

    public BytecodePatch matchStaticInitializerOnly(boolean only) {
        this.staticInitializerOnly = only;
        return this;
    }

    public BytecodePatch setInsertBefore(boolean insertBefore) {
        this.insertBefore = insertBefore;
        if (insertBefore) {
            this.insertAfter = false;
        }
        return this;
    }

    public BytecodePatch setInsertAfter(boolean insertAfter) {
        this.insertAfter = insertAfter;
        if (insertAfter) {
            this.insertBefore = false;
        }
        return this;
    }

    public BytecodePatch addPreMatchSignature(BytecodeSignature signature) {
        this.preMatchSignatures.add(signature);
        return this;
    }

    public Collection<MethodRef> getTargetMethods() {
        return this.targetMethods;
    }

    public boolean filterMethod(MethodInfo methodInfo) {
        return true;
    }

    public boolean filterMethod() {
        return this.filterMethod(this.getMethodInfo());
    }

    private boolean filterMethod1(MethodInfo methodInfo) {
        if (this.constructorOnly && !methodInfo.isConstructor()) {
            return false;
        }
        if (this.staticInitializerOnly && !methodInfo.isStaticInitializer()) {
            return false;
        }
        Collection<MethodRef> targetMethods = this.getTargetMethods();
        if (targetMethods != null && !targetMethods.isEmpty()) {
            boolean found = false;
            for (MethodRef method : targetMethods) {
                JavaRef mappedMethod = this.map(method);
                if (!methodInfo.getDescriptor().equals(mappedMethod.getType()) || !methodInfo.getName().equals(mappedMethod.getName())) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        for (MethodRef method : this.skipMethods) {
            JavaRef mappedMethod = this.map(method);
            if (!methodInfo.getDescriptor().equals(mappedMethod.getType()) || !methodInfo.getName().equals(mappedMethod.getName())) continue;
            return false;
        }
        for (BytecodeSignature signature : this.preMatchSignatures) {
            if (signature.match(null, methodInfo, null)) continue;
            return false;
        }
        return this.filterMethod();
    }

    public abstract String getMatchExpression();

    public abstract byte[] getReplacementBytes();

    private boolean apply(MethodInfo mi) throws BadBytecode {
        boolean patched = false;
        CodeAttribute ca = mi.getCodeAttribute();
        if (ca == null) {
            return patched;
        }
        this.matcher = new BytecodeMatcher(this.getMatchExpression());
        CodeIterator ci = ca.iterator();
        int oldStackSize = ca.computeMaxStack();
        int oldMaxLocals = ca.getMaxLocals();
        int offset = 0;
        ArrayList<String> txtBefore = null;
        while (this.matcher.match(mi, offset)) {
            this.classMod.addToConstPool = false;
            this.classMod.addToConstPool = true;
            this.classMod.resetLabels();
            this.labelOffset = 0;
            byte[] repl = this.getReplacementBytes();
            if (repl == null) {
                while (offset < this.matcher.getEnd() && ci.hasNext()) {
                    offset = ci.next();
                }
                continue;
            }
            this.recordPatch(String.format("%s%s@%d", mi.getName(), mi.getDescriptor(), this.matcher.getStart()));
            if ((this.insertBefore || this.insertAfter) && this.matcher.getMatchLength() > 0) {
                byte[] match = this.getMatch();
                byte[] newRepl = new byte[repl.length + match.length];
                if (this.insertBefore) {
                    System.arraycopy(repl, 0, newRepl, 0, repl.length);
                    System.arraycopy(match, 0, newRepl, repl.length, match.length);
                } else if (this.insertAfter) {
                    this.labelOffset = this.matcher.getMatchLength();
                    System.arraycopy(match, 0, newRepl, 0, match.length);
                    System.arraycopy(repl, 0, newRepl, match.length, repl.length);
                }
                repl = newRepl;
            }
            if (Logger.isLogLevel(5)) {
                txtBefore = BytecodePatch.bytecodeToString(ca, this.matcher.getStart(), this.matcher.getEnd());
            }
            int gap = repl.length - this.matcher.getMatchLength();
            int skip = 0;
            if (gap > 0) {
                skip = ci.insertGap(this.matcher.getStart(), gap) - gap;
            } else if (gap < 0) {
                skip = -gap;
                gap = 0;
            }
            for (int i = 0; i < skip; ++i) {
                ci.writeByte(0, this.matcher.getStart() + i);
            }
            this.classMod.resolveLabels(repl, this.matcher.getStart() + skip, this.labelOffset);
            ci.write(repl, this.matcher.getStart() + skip);
            offset = this.matcher.getStart() + repl.length + skip;
            if (Logger.isLogLevel(5)) {
                ArrayList<String> txtAfter = BytecodePatch.bytecodeToString(ca, this.matcher.getStart(), offset);
                BytecodePatch.logBytecodePatch(txtBefore, txtAfter);
            }
            patched = true;
            ci.move(offset);
        }
        if (patched) {
            int newMaxLocals;
            int newStackSize = ca.computeMaxStack();
            if (oldStackSize < newStackSize) {
                Logger.log(3, "increasing stack size from %d to %d", oldStackSize, newStackSize);
                ca.setMaxStack(newStackSize);
            }
            if (oldMaxLocals < (newMaxLocals = BytecodePatch.computeMaxLocals(ca))) {
                Logger.log(3, "increasing max locals from %d to %d", oldMaxLocals, newMaxLocals);
                ca.setMaxLocals(newMaxLocals);
            }
        }
        return patched;
    }

    static int computeMaxLocals(CodeAttribute ca) throws BadBytecode {
        CodeIterator ci = ca.iterator();
        int maxLocals = 0;
        block17: while (ci.hasNext()) {
            int local;
            int offset = ci.next();
            int wideReg = 0;
            block0 : switch (ci.byteAt(offset)) {
                case 30: 
                case 38: 
                case 63: 
                case 71: {
                    wideReg = 1;
                }
                case 26: 
                case 34: 
                case 42: 
                case 59: 
                case 67: 
                case 75: {
                    local = 0;
                    break;
                }
                case 31: 
                case 39: 
                case 64: 
                case 72: {
                    wideReg = 1;
                }
                case 27: 
                case 35: 
                case 43: 
                case 60: 
                case 68: 
                case 76: {
                    local = 1;
                    break;
                }
                case 32: 
                case 40: 
                case 65: 
                case 73: {
                    wideReg = 1;
                }
                case 28: 
                case 36: 
                case 44: 
                case 61: 
                case 69: 
                case 77: {
                    local = 2;
                    break;
                }
                case 33: 
                case 41: 
                case 66: 
                case 74: {
                    wideReg = 1;
                }
                case 29: 
                case 37: 
                case 45: 
                case 62: 
                case 70: 
                case 78: {
                    local = 3;
                    break;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    wideReg = 1;
                }
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: {
                    local = ci.byteAt(offset + 1) & 0xFF;
                    break;
                }
                case 196: {
                    switch (ci.byteAt(++offset)) {
                        case 22: 
                        case 24: 
                        case 55: 
                        case 57: {
                            wideReg = 1;
                        }
                        case 21: 
                        case 23: 
                        case 25: 
                        case 54: 
                        case 56: 
                        case 58: {
                            local = Util.demarshal(new byte[]{(byte)ci.byteAt(offset + 1), (byte)ci.byteAt(offset + 2)});
                            break block0;
                        }
                    }
                    continue block17;
                }
                default: {
                    continue block17;
                }
            }
            maxLocals = Math.max(maxLocals, local + wideReg + 1);
        }
        return maxLocals;
    }

    @Override
    boolean apply(ClassFile classFile) throws BadBytecode {
        boolean patched = false;
        for (Object o : classFile.getMethods()) {
            MethodInfo methodInfo;
            this.classMod.methodInfo = methodInfo = (MethodInfo)o;
            if (this.filterMethod1(methodInfo) && this.apply(methodInfo)) {
                patched = true;
            }
            this.classMod.methodInfo = null;
        }
        return patched;
    }

    private static ArrayList<String> bytecodeToString(CodeAttribute ca, int start, int end) {
        ArrayList<String> as = new ArrayList<String>();
        CodeIterator ci = ca.iterator();
        try {
            ci.move(start);
            int pos = ci.next();
            while (pos < end && ci.hasNext()) {
                int next = ci.next();
                String s = Mnemonic.OPCODE[ci.byteAt(pos++)].toUpperCase();
                while (pos < next) {
                    s = s + String.format(" 0x%02x", ci.byteAt(pos));
                    ++pos;
                }
                as.add(s);
            }
        }
        catch (Exception e) {
            as.add(e.toString());
        }
        return as;
    }

    private static void logBytecodePatch(ArrayList<String> before, ArrayList<String> after) {
        String format = "%-24s  %s";
        int max = Math.max(before.size(), after.size());
        for (int i = 0; i < max; ++i) {
            Logger.log(5, "%-24s  %s", i < before.size() ? before.get(i) : "", i < after.size() ? after.get(i) : "");
        }
    }

    protected final byte[] getCaptureGroup(int group) {
        return this.matcher.getCaptureGroup(group);
    }

    protected final byte[] getMatch() {
        return this.matcher.getMatch();
    }

    protected final ClassMod.Label label(String key) {
        return new ClassMod.Label(key, true);
    }

    protected final ClassMod.Label branch(String key) {
        return new ClassMod.Label(key, false);
    }
}

