/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BinaryMatcher {
    private final String regex;
    private Pattern pattern = null;
    private Matcher matcher = null;
    private String inputStr = null;

    public BinaryMatcher(Object ... objects) {
        this.regex = BinaryRegex.build(objects);
        if (this.regex != null) {
            this.pattern = Pattern.compile(this.regex);
        }
    }

    public boolean match(byte[] input, int offset) {
        if (this.pattern == null) {
            return false;
        }
        this.inputStr = BinaryRegex.binToStr(input);
        if (Logger.isLogLevel(6)) {
            Logger.log(6, "input  = [%s]", this.inputStr);
            Logger.log(6, "offset = [%d]", offset);
            Logger.log(6, "regex  = [%s]", this.regex);
        }
        this.matcher = this.pattern.matcher(this.inputStr);
        if (this.matcher.find(3 * offset)) {
            this.handleMatch();
            return true;
        }
        Logger.log(6, "no match", new Object[0]);
        return false;
    }

    public boolean match(byte[] input) {
        return this.match(input, 0);
    }

    public byte[] getPrefix() {
        return BinaryRegex.strToBin(this.inputStr.substring(0, this.matcher.start()));
    }

    public int getStart() {
        return this.matcher.start() / 3;
    }

    public int getEnd() {
        return this.matcher.end() / 3;
    }

    public int getMatchLength() {
        return (this.matcher.end() - this.matcher.start()) / 3;
    }

    public byte[] getMatch() {
        return BinaryRegex.strToBin(this.inputStr.substring(this.matcher.start(), this.matcher.end()));
    }

    public byte[] getSuffix() {
        return BinaryRegex.strToBin(this.inputStr.substring(this.matcher.end()));
    }

    public byte[] getCaptureGroup(int group) {
        return this.matcher.start(group) >= 0 ? BinaryRegex.strToBin(this.matcher.group(group)) : null;
    }

    private void handleMatch() {
        if (this.matcher.start() % 3 != 0) {
            throw new RuntimeException(String.format("match start %d is not divisible by %d", this.matcher.start(), 3));
        }
        if (this.matcher.end() % 3 != 0) {
            throw new RuntimeException(String.format("match end %d is not divisible by %d", this.matcher.end(), 3));
        }
        if (Logger.isLogLevel(6)) {
            Logger.log(6, "found it at %d-%d", this.matcher.start() / 3, this.matcher.end() / 3 - 1);
            Logger.log(6, " prefix = [%s]", this.inputStr.substring(0, this.matcher.start()));
            Logger.log(6, " match  = [%s]", this.inputStr.substring(this.matcher.start(), this.matcher.end()));
            Logger.log(6, " suffix = [%s]", this.inputStr.substring(this.matcher.end()));
        }
        for (int i = 1; i <= this.matcher.groupCount(); ++i) {
            if (this.matcher.start(i) < 0) continue;
            if (this.matcher.start(i) % 3 != 0) {
                throw new RuntimeException(String.format("group %d start %d is not divisible by %d", i, this.matcher.start(i), 3));
            }
            if (this.matcher.end(i) % 3 != 0) {
                throw new RuntimeException(String.format("group %d end %d is not divisible by %d", i, this.matcher.end(i), 3));
            }
            Logger.log(6, " group #%d (%d-%d) = [%s]", i, this.matcher.start(i) / 3, this.matcher.end(i) / 3, this.matcher.group(i));
        }
    }
}

