/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.prupe.mcpatcher.BinaryRegex;
import com.prupe.mcpatcher.BytecodeMatcher;
import com.prupe.mcpatcher.BytecodeSignature;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassRef;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.ConstPoolUtils;
import com.prupe.mcpatcher.FieldRef;
import com.prupe.mcpatcher.InterfaceMethodRef;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MethodRef;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.ModConfigPanel;
import com.prupe.mcpatcher.launcher.version.Library;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public final class BaseMod
extends Mod {
    private final boolean haveProfiler;

    BaseMod() {
        this.name = "__Base";
        this.author = "MCPatcher";
        this.description = "Internal mod required by the patcher.";
        this.version = "1.3";
        this.configPanel = new ConfigPanel();
        this.clearDependencies();
        this.haveProfiler = BaseMod.getMinecraftVersion().compareTo("1.3") >= 0;
        this.addClassMod(new XMinecraftMod());
        if (this.haveProfiler) {
            this.addClassMod(new ProfilerMod(this));
        }
        this.addClassFile("com.prupe.mcpatcher.MCPatcherUtils");
        this.addClassFile("com.prupe.mcpatcher.MCLogger");
        this.addClassFile("com.prupe.mcpatcher.MCLogger$1");
        this.addClassFile("com.prupe.mcpatcher.MCLogger$1$1");
        this.addClassFile("com.prupe.mcpatcher.MCLogger$ErrorLevel");
        this.addClassFile("com.prupe.mcpatcher.Config");
        this.addClassFile("com.prupe.mcpatcher.Config$ProfileEntry");
        this.addClassFile("com.prupe.mcpatcher.Config$VersionEntry");
        this.addClassFile("com.prupe.mcpatcher.Config$ModEntry");
        this.addClassFile("com.prupe.mcpatcher.Config$FileEntry");
        this.addClassFile("com.prupe.mcpatcher.JsonUtils");
        if (this.haveProfiler) {
            this.addClassFile("com.prupe.mcpatcher.ProfilerAPI");
        }
        this.addClassFile("com.prupe.mcpatcher.MAL");
        this.addFile("assets/minecraft/mcpatcher/blank.png");
    }

    @Override
    public String[] getLoggingCategories() {
        return null;
    }

    @Override
    public InputStream openFile(String name) throws IOException {
        if (name.endsWith("mcpatcher/blank.png")) {
            BufferedImage image = new BufferedImage(16, 16, 2);
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", output);
            return new ByteArrayInputStream(output.toByteArray());
        }
        return super.openFile(name);
    }

    @Override
    public void addExtraLibraries(List<Library> libraries) {
        libraries.add(new Library("com.google.code.gson:gson:2.2.2"));
    }

    public static class BiomeGenBaseMod
    extends ClassMod {
        protected final FieldRef biomeList = new FieldRef(this.getDeobfClass(), "biomeList", "[LBiomeGenBase;");
        protected final FieldRef biomeID = new FieldRef(this.getDeobfClass(), "biomeID", "I");
        protected final FieldRef biomeName = new FieldRef(this.getDeobfClass(), "biomeName", "Ljava/lang/String;");
        protected final MethodRef setBiomeName = new MethodRef(this.getDeobfClass(), "setBiomeName", "(Ljava/lang/String;)LBiomeGenBase;");

        public BiomeGenBaseMod(Mod mod) {
            super(mod);
            this.addClassSignature(new ClassMod.ConstSignature("Ocean"));
            this.addClassSignature(new ClassMod.ConstSignature("Plains"));
            this.addClassSignature(new ClassMod.ConstSignature("Desert"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 27, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, this.biomeID));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 43, BytecodeMatcher.captureReference(181), 42, 176, BinaryRegex.end());
                }
            }.setMethod(this.setBiomeName).addXref(1, this.biomeName));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.biomeList).accessFlag(8, true));
        }
    }

    public static class NBTTagListMod
    extends ClassMod {
        public NBTTagListMod(Mod mod) {
            super(mod);
            this.setParentClass("NBTBase");
            boolean haveTagAt = Mod.getMinecraftVersion().compareTo("13w36a") < 0;
            final FieldRef data = new FieldRef(this.getDeobfClass(), "data", "Ljava/util/List;");
            MethodRef tagCount = new MethodRef(this.getDeobfClass(), "tagCount", "()I");
            MethodRef removeTag = new MethodRef(this.getDeobfClass(), "removeTag", "(I)LNBTBase;");
            MethodRef tagAt = new MethodRef(this.getDeobfClass(), "tagAt", "(I)LNBTBase;");
            final InterfaceMethodRef listSize = new InterfaceMethodRef("java/util/List", "size", "()I");
            final InterfaceMethodRef listRemove = new InterfaceMethodRef("java/util/List", "remove", "(I)Ljava/lang/Object;");
            final InterfaceMethodRef listGet = new InterfaceMethodRef("java/util/List", "get", "(I)Ljava/lang/Object;");
            if (haveTagAt) {
                this.addClassSignature(new ClassMod.ConstSignature(" entries of type "));
            } else {
                this.addClassSignature(new ClassMod.ConstSignature("["));
                this.addClassSignature(new ClassMod.ConstSignature("]"));
            }
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(185, listSize)});
                }
            }.setMethod(tagCount));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(new Object[]{this.reference(185, listRemove)});
                }
            }.setMethod(removeTag));
            if (haveTagAt) {
                this.addClassSignature(new ClassMod.BytecodeSignature(){

                    @Override
                    public String getMatchExpression() {
                        return this.buildExpression(new Object[]{this.reference(185, listGet)});
                    }
                }.setMethod(tagAt));
            } else {
                this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(data));
                this.addPatch(new ClassMod.AddMethodPatch(tagAt){

                    @Override
                    public byte[] generateMethod() {
                        return this.buildCode(42, this.reference(180, data), 27, this.reference(185, listGet), this.reference(192, new ClassRef("NBTBase")), 176);
                    }
                }.allowDuplicate(true));
            }
        }
    }

    public static class NBTTagCompoundMod
    extends ClassMod {
        private final InterfaceMethodRef containsKey = new InterfaceMethodRef("java/util/Map", "containsKey", "(Ljava/lang/Object;)Z");
        private final InterfaceMethodRef mapRemove = new InterfaceMethodRef("java/util/Map", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;");
        protected final FieldRef tagMap = new FieldRef(this.getDeobfClass(), "tagMap", "Ljava/util/Map;");

        public NBTTagCompoundMod(Mod mod) {
            super(mod);
            this.setParentClass("NBTBase");
            this.addClassSignature(new ClassMod.ConstSignature(new ClassRef("java.util.HashMap")));
            if (Mod.getMinecraftVersion().compareTo("13w36a") >= 0) {
                this.addClassSignature(new ClassMod.ConstSignature("{"));
                this.addClassSignature(new ClassMod.ConstSignature("}"));
            } else {
                this.addClassSignature(new ClassMod.ConstSignature(":["));
                this.addClassSignature(new ClassMod.ConstSignature(":"));
                this.addClassSignature(new ClassMod.ConstSignature(","));
                this.addClassSignature(new ClassMod.ConstSignature("]"));
            }
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), 43, this.reference(185, NBTTagCompoundMod.this.containsKey), 172);
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "hasKey", "(Ljava/lang/String;)Z")).addXref(1, this.tagMap));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), 43, this.reference(185, NBTTagCompoundMod.this.mapRemove));
                }
            }.setMethod(new MethodRef(this.getDeobfClass(), "removeTag", "(Ljava/lang/String;)V")).addXref(1, this.tagMap));
            this.mapNBTMethod("Byte", "B");
            this.mapNBTMethod("ByteArray", "[B");
            this.mapNBTMethod("Double", "D");
            this.mapNBTMethod("Float", "F");
            this.mapNBTMethod("IntArray", "[I");
            this.mapNBTMethod("Integer", "I");
            this.mapNBTMethod("Long", "J");
            this.mapNBTMethod("Short", "S");
            this.mapNBTMethod("String", "Ljava/lang/String;");
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(null, new MethodRef(this.getDeobfClass(), "getBoolean", "(Ljava/lang/String;)Z")));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "setBoolean", "(Ljava/lang/String;Z)V")));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "getCompoundTag", "(Ljava/lang/String;)L" + this.getDeobfClass() + ";")));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "getTag", "(Ljava/lang/String;)LNBTBase;")));
        }

        public NBTTagCompoundMod mapGetTagList() {
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(new MethodRef(this.getDeobfClass(), "getTagList", "(Ljava/lang/String;)LNBTTagList;")));
            return this;
        }

        protected void mapNBTMethod(String type, String desc) {
            MethodRef get = new MethodRef(this.getDeobfClass(), "get" + type, "(Ljava/lang/String;)" + desc);
            MethodRef set = new MethodRef(this.getDeobfClass(), "set" + type, "(Ljava/lang/String;" + desc + ")V");
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(get));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(set));
        }
    }

    public static class IconMod
    extends ClassMod {
        public IconMod(Mod mod) {
            super(mod);
            InterfaceMethodRef getWidth = new InterfaceMethodRef(this.getDeobfClass(), "getWidth", "()I");
            InterfaceMethodRef getHeight = new InterfaceMethodRef(this.getDeobfClass(), "getHeight", "()I");
            InterfaceMethodRef getMinU = new InterfaceMethodRef(this.getDeobfClass(), "getMinU", "()F");
            InterfaceMethodRef getMaxU = new InterfaceMethodRef(this.getDeobfClass(), "getMaxU", "()F");
            InterfaceMethodRef getInterpolatedU = new InterfaceMethodRef(this.getDeobfClass(), "getInterpolatedU", "(D)F");
            InterfaceMethodRef getMinV = new InterfaceMethodRef(this.getDeobfClass(), "getMinV", "()F");
            InterfaceMethodRef getMaxV = new InterfaceMethodRef(this.getDeobfClass(), "getMaxV", "()F");
            InterfaceMethodRef getInterpolatedV = new InterfaceMethodRef(this.getDeobfClass(), "getInterpolatedV", "(D)F");
            InterfaceMethodRef getIconName = new InterfaceMethodRef(this.getDeobfClass(), "getIconName", "()Ljava/lang/String;");
            this.addClassSignature((ClassMod)this.new ClassMod.InterfaceSignature(getWidth, getHeight, getMinU, getMaxU, getInterpolatedU, getMinV, getMaxV, getInterpolatedV, getIconName).setInterfaceOnly(true));
        }
    }

    public static class TextureAtlasMod
    extends ClassMod {
        protected final FieldRef basePath = new FieldRef(this.getDeobfClass(), "basePath", "Ljava/lang/String;");
        protected final FieldRef texturesByName = new FieldRef(this.getDeobfClass(), "texturesByName", "Ljava/util/Map;");
        protected final MethodRef refreshTextures1 = new MethodRef(this.getDeobfClass(), "refreshTextures1", "(LResourceManager;)V");
        protected final MethodRef refreshTextures2 = new MethodRef(this.getDeobfClass(), "refreshTextures2", "(LResourceManager;)V");
        protected final MethodRef registerIcon = new MethodRef(this.getDeobfClass(), "registerIcon", "(Ljava/lang/String;)LIcon;");

        public TextureAtlasMod(Mod mod) {
            super(mod);
            this.setParentClass("AbstractTexture");
            this.setInterfaces("TickableTextureObject", "IconRegister");
            final InterfaceMethodRef mapEntrySet = new InterfaceMethodRef("java/util/Map", "entrySet", "()Ljava/util/Set;");
            final InterfaceMethodRef setIterator = new InterfaceMethodRef("java/util/Set", "iterator", "()Ljava/util/Iterator;");
            this.addClassSignature(new ClassMod.ConstSignature("missingno"));
            this.addClassSignature(new ClassMod.ConstSignature(".png"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), this.reference(185, mapEntrySet), this.reference(185, setIterator), BytecodeMatcher.anyASTORE);
                }
            }.setMethod(this.refreshTextures2).addXref(1, this.texturesByName));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 44, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, this.basePath));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.registerIcon));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.refreshTextures1, this.refreshTextures2));
        }
    }

    public static class DynamicTextureMod
    extends ClassMod {
        protected final MethodRef getRGB = new MethodRef(this.getDeobfClass(), "getRGB", "()[I");

        public DynamicTextureMod(Mod mod) {
            super(mod);
            this.setParentClass("AbstractTexture");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 27, 28, 104, 188, 10, BytecodeMatcher.anyReference(181));
                }
            }.matchConstructorOnly(true).setMethod(new MethodRef(this.getDeobfClass(), "<init>", "(II)V")));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.getRGB));
        }
    }

    public static class TextureAtlasSpriteMod
    extends ClassMod {
        protected final FieldRef textureName = new FieldRef(this.getDeobfClass(), "textureName", "Ljava/lang/String;");

        public TextureAtlasSpriteMod(Mod mod) {
            super(mod);
            this.setInterfaces("Icon");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.repeat(BinaryRegex.build(this.push(0.01f), BytecodeMatcher.anyILOAD, 135, 111, 144, BytecodeMatcher.anyFSTORE), 2));
                }
            });
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.textureName));
        }
    }

    public static class SimpleTextureMod
    extends ClassMod {
        protected final FieldRef textureName = new FieldRef(this.getDeobfClass(), "address", "LResourceLocation;");
        protected final MethodRef load = new MethodRef(this.getDeobfClass(), "load", "(LResourceManager;)V");

        public SimpleTextureMod(Mod mod) {
            super(mod);
            this.setParentClass("AbstractTexture");
            final MethodRef imageRead = new MethodRef("javax/imageio/ImageIO", "read", "(Ljava/io/InputStream;)Ljava/awt/image/BufferedImage;");
            this.addClassSignature(new ClassMod.ConstSignature("texture"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.reference(184, imageRead), BytecodeMatcher.anyASTORE);
                }
            }.setMethod(this.load));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.textureName));
        }
    }

    public static class TextureMod
    extends ClassMod {
        protected final FieldRef glTextureId = new FieldRef(this.getDeobfClass(), "glTextureId", "I");
        protected final FieldRef rgb = new FieldRef(this.getDeobfClass(), "rgb", "[I");
        protected final MethodRef getGlTextureId = new MethodRef(this.getDeobfClass(), "getGlTextureId", "()I");
        protected final MethodRef getWidth = new MethodRef(this.getDeobfClass(), "getWidth", "()I");
        protected final MethodRef getHeight = new MethodRef(this.getDeobfClass(), "getHeight", "()I");
        protected final MethodRef getRGB = new MethodRef(this.getDeobfClass(), "getRGB", "()[I");

        public TextureMod(Mod mod) {
            super(mod);
            this.setParentClass("AbstractTexture");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 27, 28, 104, 188, 10, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, this.rgb));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.getRGB));
        }
    }

    public static class AbstractTextureMod
    extends ClassMod {
        protected final FieldRef glTextureId = new FieldRef(this.getDeobfClass(), "glTextureId", "I");
        protected final MethodRef getGLTextureId = new MethodRef(this.getDeobfClass(), "getGlTextureId", "()I");

        public AbstractTextureMod(Mod mod) {
            super(mod);
            this.setInterfaces("TextureObject");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(-1), BytecodeMatcher.anyReference(181));
                }
            }.matchConstructorOnly(true));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, 180, BinaryRegex.capture(BinaryRegex.any(2)), this.push(-1), 160, BinaryRegex.any(2), 42, BytecodeMatcher.captureReference(184), 181, BinaryRegex.backReference(1));
                }
            }.setMethod(this.getGLTextureId).addXref(2, new MethodRef("TextureUtil", "newGLTexture", "()I")));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.glTextureId));
        }
    }

    public static class TextureObjectMod
    extends ClassMod {
        public TextureObjectMod(Mod mod) {
            super(mod);
            this.addClassSignature((ClassMod)this.new ClassMod.InterfaceSignature(new InterfaceMethodRef(this.getDeobfClass(), "load", "(LResourceManager;)V"), new InterfaceMethodRef(this.getDeobfClass(), "getGLTexture", "()I")).setInterfaceOnly(true));
        }
    }

    public static class TextureUtilMod
    extends ClassMod {
        protected final MethodRef glTexSubImage2D = new MethodRef("org.lwjgl.opengl.GL11", "glTexSubImage2D", "(IIIIIIIILjava/nio/IntBuffer;)V");
        protected final MethodRef glTexParameteri = new MethodRef("org.lwjgl.opengl.GL11", "glTexParameteri", "(III)V");
        protected final MethodRef glTexParameterf = new MethodRef("org.lwjgl.opengl.GL11", "glTexParameterf", "(IIF)V");
        protected final MethodRef glTexImage2D = new MethodRef("org.lwjgl.opengl.GL11", "glTexImage2D", "(IIIIIIIILjava/nio/IntBuffer;)V");

        public TextureUtilMod(Mod mod) {
            super(mod);
            this.addClassSignature(new ClassMod.ConstSignature(this.glTexImage2D));
            this.addClassSignature(new ClassMod.ConstSignature(this.glTexSubImage2D));
            this.addClassSignature(new ClassMod.OrSignature(new ClassMod.ConstSignature(this.glTexParameteri), new ClassMod.ConstSignature(this.glTexParameterf)));
        }
    }

    public static class RenderBlocksMod
    extends ClassMod {
        protected final MethodRef renderStandardBlockWithAmbientOcclusion = new MethodRef(this.getDeobfClass(), "renderStandardBlockWithAmbientOcclusion", "(LBlock;IIIFFF)Z");
        protected final FieldRef renderAllFaces = new FieldRef(this.getDeobfClass(), "renderAllFaces", "Z");
        protected final FieldRef blockAccess = new FieldRef(this.getDeobfClass(), "blockAccess", "LIBlockAccess;");
        protected final MethodRef shouldSideBeRendered = new MethodRef("Block", "shouldSideBeRendered", "(LIBlockAccess;IIII)Z");
        protected final BytecodeSignature grassTopSignature;
        protected int useColorRegister;

        public RenderBlocksMod(Mod mod) {
            super(mod);
            final MethodRef strEquals = new MethodRef("java/lang/String", "equals", "(Ljava/lang/Object;)Z");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(983055));
                }
            }.setMethod(this.renderStandardBlockWithAmbientOcclusion));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(180), 154, BinaryRegex.any(2), 43, 42, BytecodeMatcher.captureReference(180), 28, 29, this.push(1), 100, 21, 4, this.push(0), BytecodeMatcher.captureReference(182), 153, BinaryRegex.any(2));
                }
            }.setMethod(this.renderStandardBlockWithAmbientOcclusion).addXref(1, this.renderAllFaces).addXref(2, this.blockAccess).addXref(3, this.shouldSideBeRendered));
            this.addClassSignature(new ClassMod.ConstSignature(0.1875));
            this.addClassSignature(new ClassMod.ConstSignature(0.01));
            this.grassTopSignature = new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push("grass_top"), this.reference(182, strEquals), 153, BinaryRegex.any(2), this.push(0), BinaryRegex.capture(BytecodeMatcher.anyISTORE), 167, BinaryRegex.any(2));
                }

                @Override
                public boolean afterMatch() {
                    RenderBlocksMod.this.useColorRegister = BytecodeMatcher.extractRegisterNum(this.getCaptureGroup(1));
                    return true;
                }
            };
        }
    }

    public static class FontRendererMod
    extends ClassMod {
        public FontRendererMod(Mod mod) {
            super(mod);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, BytecodeMatcher.anyReference(183), 42, this.push(256), 188, 10, BytecodeMatcher.captureReference(181));
                }
            }.matchConstructorOnly(true).addXref(1, new FieldRef(this.getDeobfClass(), "charWidth", "[I")));
            this.addClassSignature(new ClassMod.OrSignature(new ClassMod.ConstSignature("0123456789abcdef"), new ClassMod.ConstSignature("0123456789abcdefk"), new ClassMod.ConstSignature("font/glyph_sizes.bin")));
        }
    }

    public static class ResourceMod
    extends ClassMod {
        public ResourceMod(Mod mod) {
            super(mod);
            this.addClassSignature((ClassMod)this.new ClassMod.InterfaceSignature(Mod.getMinecraftVersion().compareTo("13w25a") >= 0 ? null : new InterfaceMethodRef(this.getDeobfClass(), "getAddress", "()LResourceLocation;"), new InterfaceMethodRef(this.getDeobfClass(), "getInputStream", "()Ljava/io/InputStream;"), new InterfaceMethodRef(this.getDeobfClass(), "isPresent", "()Z"), new InterfaceMethodRef(this.getDeobfClass(), "getMCMeta", "(Ljava/lang/String;)LMetadataSection;")));
        }
    }

    public static class ResourceLocationSignature
    extends BytecodeSignature {
        protected static final ClassRef resourceLocationClass = new ClassRef("ResourceLocation");
        protected static final MethodRef resourceLocationInit1 = new MethodRef("ResourceLocation", "<init>", "(Ljava/lang/String;)V");
        protected final FieldRef mappedField;
        protected final String path;

        public ResourceLocationSignature(ClassMod classMod, FieldRef mappedField, String path) {
            super(classMod);
            this.mappedField = mappedField;
            this.path = path;
            this.matchStaticInitializerOnly(true);
            this.addXref(1, resourceLocationClass);
            this.addXref(2, resourceLocationInit1);
            this.addXref(3, mappedField);
        }

        @Override
        public String getMatchExpression() {
            return this.buildExpression(BytecodeMatcher.captureReference(187), 89, this.push(this.getResourcePath()), BytecodeMatcher.captureReference(183), BytecodeMatcher.captureReference(179));
        }

        protected String getResourcePath() {
            return this.path;
        }
    }

    public static class ResourceLocationMod
    extends ClassMod {
        protected final MethodRef getNamespace = new MethodRef(this.getDeobfClass(), "getNamespace", "()Ljava/lang/String;");
        protected final MethodRef getPath = new MethodRef(this.getDeobfClass(), "getPath", "()Ljava/lang/String;");

        public ResourceLocationMod(Mod mod) {
            super(mod);
            final MethodRef indexOf = new MethodRef("java/lang/String", "indexOf", "(I)I");
            this.addClassSignature(new ClassMod.ConstSignature("minecraft"));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push(58), this.reference(182, indexOf));
                }
            });
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.getPath, this.getNamespace).accessFlag(1, true).accessFlag(8, false));
        }
    }

    public static class EntityLivingMod
    extends ClassMod {
        public EntityLivingMod(Mod mod) {
            super(mod);
            this.setParentClass("EntityLivingBase");
            this.addClassSignature(new ClassMod.ConstSignature("explode"));
            this.addClassSignature(new ClassMod.ConstSignature("CanPickUpLoot"));
            this.addClassSignature(new ClassMod.ConstSignature("PersistenceRequired"));
            this.addClassSignature(new ClassMod.ConstSignature("Equipment"));
        }
    }

    public static class EntityLivingBaseMod
    extends ClassMod {
        public EntityLivingBaseMod(Mod mod) {
            super(mod);
            this.setParentClass("Entity");
            this.addClassSignature(new ClassMod.ConstSignature("HealF"));
            this.addClassSignature(new ClassMod.ConstSignature("Health"));
            this.addClassSignature(new ClassMod.ConstSignature("ActiveEffects"));
        }
    }

    public static class WorldRendererMod
    extends ClassMod {
        protected final FieldRef posX = new FieldRef(this.getDeobfClass(), "posX", "I");
        protected final FieldRef posY = new FieldRef(this.getDeobfClass(), "posY", "I");
        protected final FieldRef posZ = new FieldRef(this.getDeobfClass(), "posZ", "I");
        protected final FieldRef[] pos = new FieldRef[]{this.posX, this.posY, this.posZ};
        protected final MethodRef updateRenderer;

        public WorldRendererMod(Mod mod) {
            super(mod);
            MethodRef glNewList = new MethodRef("org.lwjgl.opengl.GL11", "glNewList", "(II)V");
            MethodRef glTranslatef = new MethodRef("org.lwjgl.opengl.GL11", "glTranslatef", "(FFF)V");
            this.updateRenderer = new MethodRef(this.getDeobfClass(), "updateRenderer", Mod.getMinecraftVersion().compareTo("13w41a") < 0 ? "()V" : "(LEntityLivingBase;)V");
            this.addClassSignature(new ClassMod.ConstSignature(glNewList));
            this.addClassSignature(new ClassMod.ConstSignature(glTranslatef));
            this.addClassSignature(new ClassMod.ConstSignature(Float.valueOf(1.000001f)));
            this.addClassSignature(new ClassMod.BytecodeSignature(){
                {
                    this.setMethod(WorldRendererMod.this.updateRenderer);
                    for (int i = 0; i < WorldRendererMod.this.pos.length; ++i) {
                        this.addXref(i + 1, WorldRendererMod.this.pos[i]);
                    }
                }

                @Override
                public String getMatchExpression() {
                    String exp0 = "";
                    String exp1 = "";
                    for (int i = 0; i < 3; ++i) {
                        exp0 = exp0 + BinaryRegex.build(42, BytecodeMatcher.captureReference(180), BytecodeMatcher.anyISTORE);
                        exp1 = exp1 + BinaryRegex.build(42, BinaryRegex.backReference(i + 1), this.push(16), 96, BytecodeMatcher.anyISTORE);
                    }
                    return this.buildExpression(exp0, exp1);
                }
            });
        }
    }

    public static class WorldClientMod
    extends ClassMod {
        public WorldClientMod(Mod mod) {
            super(mod);
            this.setParentClass("World");
            this.addClassSignature(new ClassMod.ConstSignature("MpServer"));
        }
    }

    public static class WorldMod
    extends ClassMod {
        public WorldMod(Mod mod) {
            super(mod);
            this.setInterfaces("IBlockAccess");
            this.addClassSignature(new ClassMod.ConstSignature("ambient.cave.cave"));
            this.addClassSignature(new ClassMod.ConstSignature(1013904223));
        }
    }

    public static class ItemMod
    extends ClassMod {
        protected final boolean haveItemRegistry;
        protected final MethodRef getItemName = new MethodRef(this.getDeobfClass(), "getItemName", "()Ljava/lang/String;");

        public ItemMod(Mod mod) {
            super(mod);
            boolean bl = this.haveItemRegistry = Mod.getMinecraftVersion().compareTo("13w36a") >= 0;
            if (this.haveItemRegistry) {
                this.addClassSignature(new ClassMod.ConstSignature("iron_shovel"));
                this.addClassSignature(new ClassMod.ConstSignature("iron_pickaxe"));
                this.addClassSignature(new ClassMod.ConstSignature("iron_axe"));
                this.addClassSignature(new ClassMod.ConstSignature(".name"));
            } else {
                this.addClassSignature(new ClassMod.ConstSignature("CONFLICT @ "));
                this.addClassSignature(new ClassMod.ConstSignature("coal"));
            }
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.getItemName).accessFlag(1, true).accessFlag(8, false));
        }
    }

    public static class BlockMod
    extends ClassMod {
        protected final boolean haveBlockRegistry;
        private static final ArrayList<BlockSubclassEntry> subclasses = new ArrayList<BlockSubclassEntry>(){
            {
                this.add(new BlockSubclassEntry(1, "Block", "stone", "BlockStone", "stone"));
                this.add(new BlockSubclassEntry(2, "BlockGrass", "grass", "BlockGrass", "grass"));
                this.add(new BlockSubclassEntry(3, "Block", "dirt", "BlockDirt", "dirt"));
                this.add(new BlockSubclassEntry(4, "Block", "cobblestone", "Block", "stonebrick"));
                this.add(new BlockSubclassEntry(5, "Block", "planks", "BlockWood", "wood"));
                this.add(new BlockSubclassEntry(6, "Block", "sapling", "BlockSapling", "sapling"));
                this.add(new BlockSubclassEntry(7, "Block", "bedrock", "Block", "bedrock"));
                this.add(new BlockSubclassEntry(8, "BlockFluid", "waterMoving", "BlockFlowing", "water"));
                this.add(new BlockSubclassEntry(9, "Block", "waterStill", "BlockStationary", "water"));
                this.add(new BlockSubclassEntry(10, "BlockFluid", "lavaMoving", "BlockFlowing", "lava"));
                this.add(new BlockSubclassEntry(11, "Block", "lavaStill", "BlockStationary", "lava"));
                this.add(new BlockSubclassEntry(12, "Block", "sand", "BlockSand", "sand"));
                this.add(new BlockSubclassEntry(13, "Block", "gravel", "BlockGravel", "gravel"));
                this.add(new BlockSubclassEntry(14, "Block", "oreGold", "BlockOre", "oreGold"));
                this.add(new BlockSubclassEntry(15, "Block", "oreIron", "BlockOre", "oreIron"));
                this.add(new BlockSubclassEntry(16, "Block", "oreCoal", "BlockOre", "oreCoal"));
                this.add(new BlockSubclassEntry(17, "Block", "wood", "BlockLog", "log"));
                this.add(new BlockSubclassEntry(18, "BlockLeaves", "leaves", "BlockLeaves", "leaves"));
                this.add(new BlockSubclassEntry(19, "Block", "sponge", "BlockSponge", "sponge"));
                this.add(new BlockSubclassEntry(20, "Block", "glass", "BlockGlass", "glass"));
                this.add(new BlockSubclassEntry(21, "Block", "oreLapis", "BlockOre", "oreLapis"));
                this.add(new BlockSubclassEntry(22, "Block", "blockLapis", "Block", "blockLapis"));
                this.add(new BlockSubclassEntry(23, "Block", "dispenser", "BlockDispenser", "dispenser"));
                this.add(new BlockSubclassEntry(24, "Block", "sandStone", "BlockSandStone", "sandStone"));
                this.add(new BlockSubclassEntry(25, "Block", "music", "BlockNote", "musicBlock"));
                this.add(new BlockSubclassEntry(26, "Block", "bed", "BlockBed", "bed"));
                this.add(new BlockSubclassEntry(27, "Block", "railPowered", "BlockRailPowered", "goldenRail"));
                this.add(new BlockSubclassEntry(28, "Block", "railDetector", "BlockDetectorRail", "detectorRail"));
                this.add(new BlockSubclassEntry(29, "BlockPistonBase", "pistonStickyBase", "BlockPistonBase", "pistonStickyBase"));
                this.add(new BlockSubclassEntry(30, "Block", "web", "BlockWeb", "web"));
                this.add(new BlockSubclassEntry(31, "BlockTallGrass", "tallGrass", "BlockTallGrass", "tallgrass"));
                this.add(new BlockSubclassEntry(32, "BlockDeadBush", "deadBush", "BlockDeadBush", "deadbush"));
                this.add(new BlockSubclassEntry(33, "BlockPistonBase", "pistonBase", "BlockPistonBase", "pistonBase"));
                this.add(new BlockSubclassEntry(34, "BlockPistonExtension", "pistonExtension", "BlockPistonExtension", "unnamedBlock34"));
                this.add(new BlockSubclassEntry(35, "Block", "cloth", "BlockColored", "cloth"));
                this.add(new BlockSubclassEntry(36, "BlockPistonMoving", "pistonMoving", "BlockPistonMoving", "unnamedBlock36"));
                this.add(new BlockSubclassEntry(37, "BlockFlower", "plantYellow", "BlockFlower", "flower"));
                this.add(new BlockSubclassEntry(38, "BlockFlower", "plantRed", "BlockFlower", "rose"));
                this.add(new BlockSubclassEntry(39, "BlockFlower", "mushroomBrown", "BlockMushroom", "mushroom"));
                this.add(new BlockSubclassEntry(40, "BlockFlower", "mushroomRed", "BlockMushroom", "mushroom"));
                this.add(new BlockSubclassEntry(41, "Block", "blockGold", "BlockOreStorage", "blockGold"));
                this.add(new BlockSubclassEntry(42, "Block", "blockIron", "BlockOreStorage", "blockIron"));
                this.add(new BlockSubclassEntry(43, "BlockHalfSlab", "stoneDoubleSlab", "BlockStep", "stoneSlab"));
                this.add(new BlockSubclassEntry(44, "BlockHalfSlab", "stoneSingleSlab", "BlockStep", "stoneSlab"));
                this.add(new BlockSubclassEntry(45, "Block", "brick", "Block", "brick"));
                this.add(new BlockSubclassEntry(46, "Block", "tnt", "BlockTNT", "tnt"));
                this.add(new BlockSubclassEntry(47, "Block", "bookShelf", "BlockBookshelf", "bookshelf"));
                this.add(new BlockSubclassEntry(48, "Block", "cobblestoneMossy", "Block", "stoneMoss"));
                this.add(new BlockSubclassEntry(49, "Block", "obsidian", "BlockObsidian", "obsidian"));
                this.add(new BlockSubclassEntry(50, "Block", "torchWood", "BlockTorch", "torch"));
                this.add(new BlockSubclassEntry(51, "BlockFire", "fire", "BlockFire", "fire"));
                this.add(new BlockSubclassEntry(52, "Block", "mobSpawner", "BlockMobSpawner", "mobSpawner"));
                this.add(new BlockSubclassEntry(53, "Block", "stairsWoodOak", "BlockStairs", "stairsWood"));
                this.add(new BlockSubclassEntry(54, "BlockChest", "chest", "BlockChest", "chest"));
                this.add(new BlockSubclassEntry(55, "BlockRedstoneWire", "redstoneWire", "BlockRedstoneWire", "redstoneDust"));
                this.add(new BlockSubclassEntry(56, "Block", "oreDiamond", "BlockOre", "oreDiamond"));
                this.add(new BlockSubclassEntry(57, "Block", "blockDiamond", "BlockOreStorage", "blockDiamond"));
                this.add(new BlockSubclassEntry(58, "Block", "workbench", "BlockWorkbench", "workbench"));
                this.add(new BlockSubclassEntry(59, "Block", "crops", "BlockCrops", "crops"));
                this.add(new BlockSubclassEntry(60, "Block", "tilledField", "BlockFarmland", "farmland"));
                this.add(new BlockSubclassEntry(61, "Block", "furnaceIdle", "BlockFurnace", "furnace"));
                this.add(new BlockSubclassEntry(62, "Block", "furnaceBurning", "BlockFurnace", "furnace"));
                this.add(new BlockSubclassEntry(63, "Block", "signPost", "BlockSign", "sign"));
                this.add(new BlockSubclassEntry(64, "Block", "doorWood", "BlockDoor", "doorWood"));
                this.add(new BlockSubclassEntry(65, "Block", "ladder", "BlockLadder", "ladder"));
                this.add(new BlockSubclassEntry(66, "Block", "rail", "BlockRail", "rail"));
                this.add(new BlockSubclassEntry(67, "Block", "stairsCobblestone", "BlockStairs", "stairsStone"));
                this.add(new BlockSubclassEntry(68, "Block", "signWall", "BlockSign", "sign"));
                this.add(new BlockSubclassEntry(69, "Block", "lever", "BlockLever", "lever"));
                this.add(new BlockSubclassEntry(70, "Block", "pressurePlateStone", "BlockPressurePlate", "pressurePlate"));
                this.add(new BlockSubclassEntry(71, "Block", "doorIron", "BlockDoor", "doorIron"));
                this.add(new BlockSubclassEntry(72, "Block", "pressurePlatePlanks", "BlockPressurePlate", "pressurePlate"));
                this.add(new BlockSubclassEntry(73, "Block", "oreRedstone", "BlockRedstoneOre", "oreRedstone"));
                this.add(new BlockSubclassEntry(74, "Block", "oreRedstoneGlowing", "BlockRedstoneOre", "oreRedstone"));
                this.add(new BlockSubclassEntry(75, "Block", "torchRedstoneIdle", "BlockRedstoneTorch", "notGate"));
                this.add(new BlockSubclassEntry(76, "Block", "torchRedstoneActive", "BlockRedstoneTorch", "notGate"));
                this.add(new BlockSubclassEntry(77, "Block", "stoneButton", "BlockButtonStone", "button"));
                this.add(new BlockSubclassEntry(78, "Block", "snow", "BlockSnow", "snow"));
                this.add(new BlockSubclassEntry(79, "Block", "ice", "BlockIce", "ice"));
                this.add(new BlockSubclassEntry(80, "Block", "blockSnow", "BlockSnowBlock", "snow"));
                this.add(new BlockSubclassEntry(81, "Block", "cactus", "BlockCactus", "cactus"));
                this.add(new BlockSubclassEntry(82, "Block", "blockClay", "BlockClay", "clay"));
                this.add(new BlockSubclassEntry(83, "Block", "reed", "BlockReed", "reeds"));
                this.add(new BlockSubclassEntry(84, "Block", "jukebox", "BlockJukeBox", "jukebox"));
                this.add(new BlockSubclassEntry(85, "Block", "fence", "BlockFence", "fence"));
                this.add(new BlockSubclassEntry(86, "Block", "pumpkin", "BlockPumpkin", "pumpkin"));
                this.add(new BlockSubclassEntry(87, "Block", "netherrack", "BlockNetherrack", "hellrock"));
                this.add(new BlockSubclassEntry(88, "Block", "slowSand", "BlockSoulSand", "hellsand"));
                this.add(new BlockSubclassEntry(89, "Block", "glowStone", "BlockGlowStone", "lightgem"));
                this.add(new BlockSubclassEntry(90, "BlockPortal", "portal", "BlockPortal", "portal"));
                this.add(new BlockSubclassEntry(91, "Block", "pumpkinLantern", "BlockPumpkin", "litpumpkin"));
                this.add(new BlockSubclassEntry(92, "Block", "cake", "BlockCake", "cake"));
                this.add(new BlockSubclassEntry(93, "BlockRedstoneRepeater", "redstoneRepeaterIdle", "BlockRedstoneRepeater", "diode"));
                this.add(new BlockSubclassEntry(94, "BlockRedstoneRepeater", "redstoneRepeaterActive", "BlockRedstoneRepeater", "diode"));
                this.add(new BlockSubclassEntry(95, "Block", "lockedChest", "BlockLockedChest", "lockedchest"));
                this.add(new BlockSubclassEntry(96, "Block", "trapdoor", "BlockTrapDoor", "trapdoor"));
                this.add(new BlockSubclassEntry(97, "Block", "silverfish", "BlockSilverfish", "monsterStoneEgg"));
                this.add(new BlockSubclassEntry(98, "Block", "stoneBrick", "BlockStoneBrick", "stonebricksmooth"));
                this.add(new BlockSubclassEntry(99, "Block", "mushroomCapBrown", "BlockMushroomCap", "mushroom"));
                this.add(new BlockSubclassEntry(100, "Block", "mushroomCapRed", "BlockMushroomCap", "mushroom"));
                this.add(new BlockSubclassEntry(101, "Block", "fenceIron", "BlockPane", "fenceIron"));
                this.add(new BlockSubclassEntry(102, "Block", "thinGlass", "BlockPane", "thinGlass"));
                this.add(new BlockSubclassEntry(103, "Block", "melon", "BlockMelon", "melon"));
                this.add(new BlockSubclassEntry(104, "Block", "pumpkinStem", "BlockStem", "pumpkinStem"));
                this.add(new BlockSubclassEntry(105, "Block", "melonStem", "BlockStem", "pumpkinStem"));
                this.add(new BlockSubclassEntry(106, "Block", "vine", "BlockVine", "vine"));
                this.add(new BlockSubclassEntry(107, "Block", "fenceGate", "BlockFenceGate", "fenceGate"));
                this.add(new BlockSubclassEntry(108, "Block", "stairsBrick", "BlockStairs", "stairsBrick"));
                this.add(new BlockSubclassEntry(109, "Block", "stairsStoneBrick", "BlockStairs", "stairsStoneBrickSmooth"));
                this.add(new BlockSubclassEntry(110, "BlockMycelium", "mycelium", "BlockMycelium", "mycel"));
                this.add(new BlockSubclassEntry(111, "Block", "waterlily", "BlockLilyPad", "waterlily"));
                this.add(new BlockSubclassEntry(112, "Block", "netherBrick", "Block", "netherBrick"));
                this.add(new BlockSubclassEntry(113, "Block", "netherFence", "BlockFence", "netherFence"));
                this.add(new BlockSubclassEntry(114, "Block", "stairsNetherBrick", "BlockStairs", "stairsNetherBrick"));
                this.add(new BlockSubclassEntry(115, "Block", "netherStalk", "BlockNetherStalk", "netherStalk"));
                this.add(new BlockSubclassEntry(116, "Block", "enchantmentTable", "BlockEnchantmentTable", "enchantmentTable"));
                this.add(new BlockSubclassEntry(117, "Block", "brewingStand", "BlockBrewingStand", "brewingStand"));
                this.add(new BlockSubclassEntry(118, "BlockCauldron", "cauldron", "BlockCauldron", "cauldron"));
                this.add(new BlockSubclassEntry(119, "Block", "endPortal", "BlockEndPortal", "unnamedBlock119"));
                this.add(new BlockSubclassEntry(120, "Block", "endPortalFrame", "BlockEndPortalFrame", "endPortalFrame"));
                this.add(new BlockSubclassEntry(121, "Block", "whiteStone", "Block", "whiteStone"));
                this.add(new BlockSubclassEntry(122, "Block", "dragonEgg", "BlockDragonEgg", "dragonEgg"));
                this.add(new BlockSubclassEntry(123, "Block", "redstoneLampIdle", "BlockRedstoneLight", "redstoneLight"));
                this.add(new BlockSubclassEntry(124, "Block", "redstoneLampActive", "BlockRedstoneLight", "redstoneLight"));
                this.add(new BlockSubclassEntry(125, "BlockHalfSlab", "woodDoubleSlab", "BlockWoodSlab", "woodSlab"));
                this.add(new BlockSubclassEntry(126, "BlockHalfSlab", "woodSingleSlab", "BlockWoodSlab", "woodSlab"));
                this.add(new BlockSubclassEntry(127, "Block", "cocoaPlant", "BlockCocoa", "cocoa"));
                this.add(new BlockSubclassEntry(128, "Block", "stairsSandStone", "BlockStairs", "stairsSandStone"));
                this.add(new BlockSubclassEntry(129, "Block", "oreEmerald", "BlockOre", "oreEmerald"));
                this.add(new BlockSubclassEntry(130, "Block", "enderChest", "BlockEnderChest", "enderChest"));
                this.add(new BlockSubclassEntry(131, "BlockTripWireSource", "tripWireSource", "BlockTripWireSource", "tripWireSource"));
                this.add(new BlockSubclassEntry(132, "Block", "tripWire", "BlockTripWire", "tripWire"));
                this.add(new BlockSubclassEntry(133, "Block", "blockEmerald", "BlockOreStorage", "blockEmerald"));
                this.add(new BlockSubclassEntry(134, "Block", "stairsWoodSpruce", "BlockStairs", "stairsWoodSpruce"));
                this.add(new BlockSubclassEntry(135, "Block", "stairsWoodBirch", "BlockStairs", "stairsWoodBirch"));
                this.add(new BlockSubclassEntry(136, "Block", "stairsWoodJungle", "BlockStairs", "stairsWoodJungle"));
                this.add(new BlockSubclassEntry(137, "Block", "commandBlock", "BlockCommandBlock", "commandBlock"));
                this.add(new BlockSubclassEntry(138, "BlockBeacon", "beacon", "BlockBeacon", "beacon"));
                this.add(new BlockSubclassEntry(139, "Block", "cobblestoneWall", "BlockWall", "cobbleWall"));
                this.add(new BlockSubclassEntry(140, "Block", "flowerPot", "BlockFlowerPot", "flowerPot"));
                this.add(new BlockSubclassEntry(141, "Block", "carrot", "BlockCarrot", "carrots"));
                this.add(new BlockSubclassEntry(142, "Block", "potato", "BlockPotato", "potatoes"));
                this.add(new BlockSubclassEntry(143, "Block", "woodenButton", "BlockButtonWood", "button"));
                this.add(new BlockSubclassEntry(144, "Block", "skull", "BlockSkull", "skull"));
                this.add(new BlockSubclassEntry(145, "Block", "anvil", "BlockAnvil", "anvil"));
                this.add(new BlockSubclassEntry(146, "Block", "chestTrapped", "BlockChest", "chestTrap"));
                this.add(new BlockSubclassEntry(147, "Block", "pressurePlateGold", "BlockPressurePlateWeighted", "weightedPlate_light"));
                this.add(new BlockSubclassEntry(148, "Block", "pressurePlateIron", "BlockPressurePlateWeighted", "weightedPlate_heavy"));
                this.add(new BlockSubclassEntry(149, "BlockComparator", "redstoneComparatorIdle", "BlockComparator", "comparator"));
                this.add(new BlockSubclassEntry(150, "BlockComparator", "redstoneComparatorActive", "BlockComparator", "comparator"));
                this.add(new BlockSubclassEntry(151, "BlockDaylightDetector", "daylightSensor", "BlockDaylightDetector", "daylightDetector"));
                this.add(new BlockSubclassEntry(152, "Block", "blockRedstone", "BlockPoweredOre", "blockRedstone"));
                this.add(new BlockSubclassEntry(153, "Block", "oreNetherQuartz", "BlockOre", "netherquartz"));
                this.add(new BlockSubclassEntry(154, "BlockHopper", "hopperBlock", "BlockHopper", "hopper"));
                this.add(new BlockSubclassEntry(155, "Block", "blockNetherQuartz", "BlockQuartz", "quartzBlock"));
                this.add(new BlockSubclassEntry(156, "Block", "stairsNetherQuartz", "BlockStairs", "stairsQuartz"));
                this.add(new BlockSubclassEntry(157, "Block", "railActivator", "BlockRailPowered", "activatorRail"));
                this.add(new BlockSubclassEntry(158, "Block", "dropper", "BlockDropper", "dropper"));
                this.add(new BlockSubclassEntry(159, "Block", "clayHardenedStained", "BlockColored", "clayHardenedStained"));
                this.add(new BlockSubclassEntry(170, "Block", "hayBlock", "BlockHay", "hayBlock"));
                this.add(new BlockSubclassEntry(171, "Block", "woolCarpet", "BlockCarpet", "woolCarpet"));
                this.add(new BlockSubclassEntry(172, "Block", "clayHardened", "Block", "clayHardened"));
                this.add(new BlockSubclassEntry(173, "Block", "blockCoal", "Block", "blockCoal"));
            }
        };

        public BlockMod(Mod mod) {
            super(mod);
            boolean bl = this.haveBlockRegistry = Mod.getMinecraftVersion().compareTo("13w36a") >= 0;
            if (this.haveBlockRegistry) {
                this.addClassSignature(new ClassMod.ConstSignature("stone"));
                this.addClassSignature(new ClassMod.ConstSignature("grass"));
                this.addClassSignature(new ClassMod.ConstSignature("dirt"));
                this.addClassSignature(new ClassMod.ConstSignature(".name"));
            } else {
                this.addClassSignature(new ClassMod.ConstSignature(" is already occupied by "));
                this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(new FieldRef(this.getDeobfClass(), "blockID", "I")).accessFlag(1, true).accessFlag(8, false).accessFlag(16, true));
                this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(new FieldRef(this.getDeobfClass(), "blocksList", "[LBlock;")).accessFlag(1, true).accessFlag(8, true).accessFlag(16, true));
            }
        }

        protected void addBlockSignatures() {
            for (BlockSubclassEntry entry : subclasses) {
                this.addBlockSignature(entry.blockID, entry.fieldClass, entry.fieldName, entry.className, entry.blockName);
            }
        }

        protected void addBlockSignature(String name) {
            for (BlockSubclassEntry entry : subclasses) {
                if (!entry.className.equals(name) && !entry.blockName.equals(name) && !entry.fieldName.equals(name)) continue;
                this.addBlockSignature(entry.blockID, entry.fieldClass, entry.fieldName, entry.className, entry.blockName);
                return;
            }
            throw new RuntimeException("unknown Block subclass: " + name);
        }

        protected void addBlockSignature(int blockID) {
            for (BlockSubclassEntry entry : subclasses) {
                if (entry.blockID != blockID) continue;
                this.addBlockSignature(entry.blockID, entry.fieldClass, entry.fieldName, entry.className, entry.blockName);
                return;
            }
            throw new RuntimeException("unknown Block subclass: block ID" + blockID);
        }

        protected void addBlockSignature(final int blockID, String fieldClass, String fieldName, String className, final String blockName) {
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BytecodeMatcher.captureReference(187), 89, blockID == 35 ? "" : this.push(blockID), BinaryRegex.nonGreedy(BinaryRegex.any(0, 60)), blockName.startsWith("unnamedBlock") ? "" : BinaryRegex.build(this.push(blockName), BytecodeMatcher.anyReference(182)), BinaryRegex.nonGreedy(BinaryRegex.any(0, 20)), BytecodeMatcher.captureReference(179));
                }
            }.matchStaticInitializerOnly(true).addXref(1, new ClassRef(className)).addXref(2, new FieldRef(this.getDeobfClass(), fieldName, "L" + fieldClass + ";")));
        }

        private static class BlockSubclassEntry {
            final int blockID;
            final String fieldClass;
            final String fieldName;
            final String className;
            final String blockName;

            BlockSubclassEntry(int blockID, String fieldClass, String fieldName, String className, String blockName) {
                this.blockID = blockID;
                this.fieldClass = fieldClass;
                this.fieldName = fieldName;
                this.className = className;
                this.blockName = blockName;
            }
        }
    }

    public static class IBlockAccessMod
    extends ClassMod {
        protected final boolean haveBlockRegistry = Mod.getMinecraftVersion().compareTo("13w36a") >= 0;
        protected final boolean methodsRemoved = Mod.getMinecraftVersion().compareTo("13w38b") >= 0;

        public IBlockAccessMod(Mod mod) {
            super(mod);
            this.addClassSignature((ClassMod)this.new ClassMod.InterfaceSignature(this.haveBlockRegistry ? new InterfaceMethodRef(this.getDeobfClass(), "getBlock", "(III)LBlock;") : new InterfaceMethodRef(this.getDeobfClass(), "getBlockId", "(III)I"), new InterfaceMethodRef(this.getDeobfClass(), "getBlockTileEntity", "(III)LTileEntity;"), new InterfaceMethodRef(this.getDeobfClass(), "getLightBrightnessForSkyBlocks", "(IIII)I"), this.methodsRemoved ? null : new InterfaceMethodRef(this.getDeobfClass(), "getBrightness", "(IIII)F"), this.methodsRemoved ? null : new InterfaceMethodRef(this.getDeobfClass(), "getLightBrightness", "(III)F"), new InterfaceMethodRef(this.getDeobfClass(), "getBlockMetadata", "(III)I"), this.methodsRemoved ? null : new InterfaceMethodRef(this.getDeobfClass(), "getBlockMaterial", "(III)LMaterial;"), this.methodsRemoved ? null : new InterfaceMethodRef(this.getDeobfClass(), "isBlockOpaqueCube", "(III)Z"), this.methodsRemoved ? null : new InterfaceMethodRef(this.getDeobfClass(), "isBlockNormalCube", "(III)Z"), new InterfaceMethodRef(this.getDeobfClass(), "isAirBlock", "(III)Z"), new InterfaceMethodRef(this.getDeobfClass(), "getBiomeGenAt", "(II)LBiomeGenBase;"), new InterfaceMethodRef(this.getDeobfClass(), "getHeight", "()I"), new InterfaceMethodRef(this.getDeobfClass(), "extendedLevelsInChunkCache", "()Z"), this.methodsRemoved ? null : new InterfaceMethodRef(this.getDeobfClass(), "doesBlockHaveSolidTopSurface", "(III)Z"), new InterfaceMethodRef(this.getDeobfClass(), "getWorldVec3Pool", "()LVec3Pool;"), new InterfaceMethodRef(this.getDeobfClass(), "isBlockProvidingPowerTo", "(IIII)I")).setInterfaceOnly(true));
        }
    }

    public static class TessellatorMod
    extends ClassMod {
        protected final MethodRef draw = new MethodRef(this.getDeobfClass(), "draw", "()I");
        protected final MethodRef startDrawingQuads = new MethodRef(this.getDeobfClass(), "startDrawingQuads", "()V");
        protected final MethodRef startDrawing = new MethodRef(this.getDeobfClass(), "startDrawing", "(I)V");
        protected final MethodRef addVertexWithUV = new MethodRef(this.getDeobfClass(), "addVertexWithUV", "(DDDDD)V");
        protected final MethodRef addVertex = new MethodRef(this.getDeobfClass(), "addVertex", "(DDD)V");
        protected final MethodRef setTextureUV = new MethodRef(this.getDeobfClass(), "setTextureUV", "(DD)V");
        protected final MethodRef setColorOpaque_F = new MethodRef(this.getDeobfClass(), "setColorOpaque_F", "(FFF)V");
        protected final FieldRef instance = new FieldRef(this.getDeobfClass(), "instance", "LTessellator;");

        public TessellatorMod(Mod mod) {
            super(mod);
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(this.push("Not tesselating!"));
                }
            }.setMethod(this.draw));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, this.push(7), BytecodeMatcher.captureReference(182), 177);
                }
            }.setMethod(this.startDrawingQuads).addXref(1, this.startDrawing));
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, 24, 7, 24, 9, BytecodeMatcher.captureReference(182), 42, 39, 41, 24, 5, BytecodeMatcher.captureReference(182), 177);
                }
            }.setMethod(this.addVertexWithUV).addXref(1, this.setTextureUV).addXref(2, this.addVertex));
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(this.instance).accessFlag(8, true));
            this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.setColorOpaque_F));
        }
    }

    public static class ProfilerMod
    extends ClassMod {
        public ProfilerMod(Mod mod) {
            super(mod);
            this.addClassSignature(new ClassMod.ConstSignature("root"));
            this.addClassSignature(new ClassMod.ConstSignature("[UNKNOWN]"));
            this.addClassSignature(new ClassMod.ConstSignature(100.0));
            MethodRef startSection = new MethodRef(this.getDeobfClass(), "startSection", "(Ljava/lang/String;)V");
            MethodRef endSection = new MethodRef(this.getDeobfClass(), "endSection", "()V");
            MethodRef endStartSection = new MethodRef(this.getDeobfClass(), "endStartSection", "(Ljava/lang/String;)V");
            this.addClassSignature(new ClassMod.BytecodeSignature(){

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(42, BytecodeMatcher.captureReference(182), 42, 43, BytecodeMatcher.captureReference(182));
                }
            }.setMethod(endStartSection).addXref(1, endSection).addXref(2, startSection));
        }
    }

    public static class MinecraftMod
    extends ClassMod {
        protected final FieldRef instance = new FieldRef(this.getDeobfClass(), "instance", "LMinecraft;");
        protected final MethodRef getInstance = new MethodRef(this.getDeobfClass(), "getInstance", "()LMinecraft;");
        protected final boolean haveGetInstance;

        public MinecraftMod(Mod mod) {
            super(mod);
            boolean bl = this.haveGetInstance = Mod.getMinecraftVersion().compareTo("1.3") >= 0;
            if (Mod.getMinecraftVersion().compareTo("13w16a") >= 0) {
                this.addClassSignature(new ClassMod.ConstSignature("textures/gui/title/mojang.png"));
                this.addClassSignature(new ClassMod.ConstSignature("crash-reports"));
            } else {
                this.addClassSignature(new ClassMod.FilenameSignature("net/minecraft/client/Minecraft.class"));
            }
            if (this.haveGetInstance) {
                this.addMemberMapper((ClassMod)this.new ClassMod.MethodMapper(this.getInstance).accessFlag(1, true).accessFlag(8, true));
            }
        }

        public MinecraftMod mapWorldClient() {
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(new FieldRef(this.getDeobfClass(), "theWorld", "LWorldClient;")));
            return this;
        }

        public MinecraftMod mapPlayer() {
            this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(new FieldRef(this.getDeobfClass(), "thePlayer", "LEntityClientPlayerMP;")));
            return this;
        }

        public MinecraftMod addWorldGetter() {
            MethodRef getWorld = new MethodRef(this.getDeobfClass(), "getWorld", "()LWorld;");
            if (Mod.getMinecraftVersion().compareTo("12w18a") >= 0) {
                final FieldRef worldServer = new FieldRef(this.getDeobfClass(), "worldServer", "LWorldServer;");
                final FieldRef world = new FieldRef("WorldServer", "world", "LWorld;");
                this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(worldServer));
                this.addPatch(new ClassMod.AddMethodPatch(getWorld){

                    @Override
                    public byte[] generateMethod() {
                        return this.buildCode(42, this.reference(180, worldServer), this.reference(180, world), 176);
                    }
                });
            } else {
                final FieldRef theWorld = new FieldRef(this.getDeobfClass(), "theWorld", "LWorld;");
                this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(theWorld));
                this.addPatch(new ClassMod.AddMethodPatch(getWorld){

                    @Override
                    public byte[] generateMethod() {
                        return this.buildCode(42, this.reference(180, theWorld), 176);
                    }
                });
            }
            return this;
        }
    }

    private class XMinecraftMod
    extends MinecraftMod {
        XMinecraftMod() {
            super(BaseMod.this);
            if (BaseMod.this.haveProfiler) {
                this.addMemberMapper((ClassMod)this.new ClassMod.FieldMapper(new FieldRef(this.getDeobfClass(), "mcProfiler", "LProfiler;")));
            }
            this.addPatch(new ClassMod.BytecodePatch(){

                @Override
                public String getDescription() {
                    return "MCPatcherUtils.setMinecraft(this)";
                }

                @Override
                public String getMatchExpression() {
                    return this.buildExpression(BinaryRegex.begin(), 42, this.reference(183, new MethodRef("java.lang.Object", "<init>", "()V")));
                }

                @Override
                public byte[] getReplacementBytes() {
                    ArrayList<String> descriptor = ConstPoolUtils.parseDescriptor(this.getMethodInfo().getDescriptor());
                    return this.buildCode(this.getFileArgument(descriptor, 6), this.getFileArgument(descriptor, 7), this.push(Mod.getMinecraftVersion().getVersionString()), this.push(MCPatcher.VERSION_STRING), this.reference(184, new MethodRef("com.prupe.mcpatcher.MCPatcherUtils", "setMinecraft", "(Ljava/io/File;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V")));
                }

                private byte[] getFileArgument(List<String> descriptor, int index) {
                    if (descriptor.size() > index - 1 && "Ljava/io/File;".equals(descriptor.get(index - 1))) {
                        return BytecodeMatcher.registerLoadStore(25, index);
                    }
                    return this.buildCode(1);
                }
            }.setInsertAfter(true).matchConstructorOnly(true));
            if (!this.haveGetInstance) {
                this.addPatch((ClassMod)this.new ClassMod.AddFieldPatch(this.instance, 9));
                this.addPatch(new ClassMod.BytecodePatch(){

                    @Override
                    public String getDescription() {
                        return "set instance";
                    }

                    @Override
                    public String getMatchExpression() {
                        return this.buildExpression(BinaryRegex.begin(), 42, this.reference(183, new MethodRef("java.lang.Object", "<init>", "()V")));
                    }

                    @Override
                    public byte[] getReplacementBytes() {
                        return this.buildCode(42, this.reference(179, XMinecraftMod.this.instance));
                    }
                }.setInsertAfter(true).matchConstructorOnly(true));
                this.addPatch(new ClassMod.AddMethodPatch(this.getInstance, 9){

                    @Override
                    public byte[] generateMethod() {
                        return this.buildCode(this.reference(178, XMinecraftMod.this.instance), 176);
                    }
                });
            }
        }

        @Override
        public String getDeobfClass() {
            return "Minecraft";
        }
    }

    class ConfigPanel
    extends ModConfigPanel {
        private JPanel panel;
        private JCheckBox fetchURLCheckBox;
        private JCheckBox profilingCheckBox;
        private JTable logTable;

        ConfigPanel() {
            this.$$$setupUI$$$();
            this.fetchURLCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.getInstance().fetchRemoteVersionList = ConfigPanel.this.fetchURLCheckBox.isSelected();
                }
            });
            this.profilingCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Config.getInstance().extraProfiling = ConfigPanel.this.profilingCheckBox.isSelected();
                }
            });
            this.logTable.setModel(new TableModel(){

                private List<String> getCategories() {
                    ArrayList<String> allCategories = new ArrayList<String>();
                    for (Mod mod : MCPatcher.modList.getAll()) {
                        String[] categories = mod.getLoggingCategories();
                        if (categories == null) continue;
                        for (String category : categories) {
                            if (category == null) continue;
                            allCategories.add(category);
                        }
                    }
                    return allCategories;
                }

                private String getCategory(int rowIndex) {
                    List<String> categories = this.getCategories();
                    return rowIndex >= 0 && rowIndex < categories.size() ? categories.get(rowIndex) : null;
                }

                @Override
                public int getRowCount() {
                    return this.getCategories().size();
                }

                @Override
                public int getColumnCount() {
                    return 2;
                }

                @Override
                public String getColumnName(int columnIndex) {
                    return null;
                }

                @Override
                public Class<?> getColumnClass(int columnIndex) {
                    return String.class;
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return columnIndex == 1;
                }

                @Override
                public Object getValueAt(int rowIndex, int columnIndex) {
                    String category = this.getCategory(rowIndex);
                    if (category == null) {
                        return null;
                    }
                    return columnIndex == 0 ? category : Config.getLogLevel(category);
                }

                @Override
                public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
                    String category = this.getCategory(rowIndex);
                    if (columnIndex != 1 || category == null) {
                        return;
                    }
                    try {
                        Config.setLogLevel(category, Level.parse(aValue.toString()));
                    }
                    catch (IllegalArgumentException e) {
                        // empty catch block
                    }
                }

                @Override
                public void addTableModelListener(TableModelListener l) {
                }

                @Override
                public void removeTableModelListener(TableModelListener l) {
                }
            });
            JComboBox<Level> combo = new JComboBox<Level>();
            combo.addItem(Level.OFF);
            combo.addItem(Level.SEVERE);
            combo.addItem(Level.WARNING);
            combo.addItem(Level.INFO);
            combo.addItem(Level.CONFIG);
            combo.addItem(Level.FINE);
            combo.addItem(Level.FINER);
            combo.addItem(Level.FINEST);
            combo.addItem(Level.ALL);
            this.logTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(combo));
        }

        @Override
        public JPanel getPanel() {
            return this.panel;
        }

        @Override
        public String getPanelName() {
            return "General options";
        }

        @Override
        public void load() {
            Config config = Config.getInstance();
            this.fetchURLCheckBox.setSelected(config.fetchRemoteVersionList);
            this.profilingCheckBox.setSelected(config.extraProfiling);
            this.showAdvancedOption(this.profilingCheckBox);
        }

        @Override
        public void save() {
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JCheckBox jCheckBox;
            JCheckBox jCheckBox2;
            JTable jTable;
            JPanel jPanel;
            this.panel = jPanel = new JPanel();
            jPanel.setLayout(new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
            this.logTable = jTable = new JTable();
            jPanel.add((Component)jTable, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 6, null, new Dimension(150, 50), null));
            JLabel jLabel = new JLabel();
            jLabel.setText("Game debug logging:");
            jPanel.add((Component)jLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.profilingCheckBox = jCheckBox2 = new JCheckBox();
            jCheckBox2.setToolTipText("More information on the Shift-F3 debug screen.");
            jCheckBox2.setText("Enable extra performance profiling");
            jPanel.add((Component)jCheckBox2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
            this.fetchURLCheckBox = jCheckBox = new JCheckBox();
            jCheckBox.setText("Fetch list of Minecraft versions on startup");
            jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.panel;
        }
    }
}

