/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.prupe.mcpatcher.Config;
import com.prupe.mcpatcher.ExternalMod;
import com.prupe.mcpatcher.Logger;
import com.prupe.mcpatcher.MCPatcher;
import com.prupe.mcpatcher.MCPatcherUtils;
import com.prupe.mcpatcher.MainForm;
import com.prupe.mcpatcher.MinecraftJar;
import com.prupe.mcpatcher.Mod;
import com.prupe.mcpatcher.ZipTreeDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.DefaultTableModel;

class AddModDialog
extends JDialog {
    private JPanel contentPane;
    private JButton buttonOK;
    private JButton buttonCancel;
    private JTextField inputField;
    private JButton browseButton;
    private JTable fileTable;
    private JButton addButton;
    private JButton removeButton;
    private JScrollPane fileTableScrollPane;
    private final JPanel parent;
    private final File defaultModDir;
    private File file;
    private ZipFile zipFile;
    private ZipTreeDialog zipDialog;
    private final HashMap<String, String> fileMap;
    private ExternalMod mod;
    private boolean editMode;

    AddModDialog(JPanel parent) {
        this(parent, null);
    }

    AddModDialog(JPanel parent, ExternalMod mod) {
        this.parent = parent;
        this.$$$setupUI$$$();
        String version = MCPatcher.minecraft.getVersion().getVersionString();
        this.defaultModDir = MCPatcherUtils.getMinecraftPath("mods", version);
        this.fileMap = new HashMap();
        if (mod != null) {
            this.mod = mod;
            this.editMode = true;
            this.zipFile = mod.zipFile;
            this.file = new File(this.zipFile.getName());
            this.inputField.setText(this.zipFile.getName());
            this.fileMap.putAll(mod.fileMap);
        }
        MainForm.setIconImage(this);
        this.setContentPane(this.contentPane);
        this.fileTableScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.setTitle("Add external mod");
        this.setMinimumSize(new Dimension(512, 512));
        this.setResizable(true);
        this.setModal(true);
        this.pack();
        this.getRootPane().setDefaultButton(this.buttonOK);
        this.buttonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.onOK();
            }
        });
        this.buttonCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                AddModDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.showBrowseDialog();
            }
        });
        this.fileTableScrollPane.getViewport().setBackground(this.fileTable.getBackground());
        this.fileTable.setModel(new FileTableModel());
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddModDialog.this.showZipDialog(true);
            }
        });
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int rowIndex;
                FileTableModel model = (FileTableModel)AddModDialog.this.fileTable.getModel();
                while ((rowIndex = AddModDialog.this.fileTable.getSelectedRow()) >= 0) {
                    Map.Entry<String, String> row = model.getRow(rowIndex);
                    if (row == null) continue;
                    AddModDialog.this.fileMap.remove(row.getKey());
                    model.fireTableRowsDeleted(rowIndex, rowIndex);
                }
            }
        });
        this.updateControls();
    }

    @Override
    public void dispose() {
        this.hideZipDialog();
        if (!this.editMode) {
            MCPatcherUtils.close(this.zipFile);
        }
        this.zipFile = null;
        super.dispose();
    }

    private void onOK() {
        if (this.zipFile == null || this.fileMap == null) {
            this.onCancel();
            return;
        }
        if (this.mod == null) {
            this.mod = new ExternalMod(this.zipFile, this.fileMap);
        } else {
            this.mod.setFileMap(this.fileMap);
        }
        this.zipFile = null;
        this.dispose();
    }

    private void onCancel() {
        this.mod = null;
        this.dispose();
    }

    private void updateControls() {
        boolean exists = new File(this.inputField.getText()).exists();
        this.browseButton.setVisible(!this.editMode);
        this.addButton.setEnabled(exists);
        this.removeButton.setEnabled(exists);
    }

    File showBrowseDialog() {
        JFileChooser fd = new JFileChooser();
        fd.setFileSelectionMode(0);
        fd.setFileHidingEnabled(false);
        fd.setDialogTitle("Select mod zip file");
        try {
            String modDirString = Config.getInstance().lastModDirectory;
            if (modDirString == null) {
                modDirString = "";
            }
            File lastModDir = new File(modDirString);
            if (modDirString.equals("")) {
                this.defaultModDir.mkdirs();
                fd.setCurrentDirectory(this.defaultModDir);
            } else if (lastModDir.isDirectory()) {
                fd.setCurrentDirectory(lastModDir);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        fd.setAcceptAllFileFilterUsed(false);
        fd.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || ExternalMod.isValidPath(f);
            }

            @Override
            public String getDescription() {
                return ExternalMod.getFileTypePattern();
            }
        });
        this.file = fd.showOpenDialog(this.parent) == 0 ? fd.getSelectedFile() : null;
        return this.file;
    }

    boolean showFileListDialog() {
        if (this.file == null || !this.file.isFile()) {
            return false;
        }
        this.inputField.setText(this.file.getPath());
        File lastModDir = this.file.getParentFile();
        Config.getInstance().lastModDirectory = lastModDir.equals(this.defaultModDir) ? null : lastModDir.getAbsolutePath();
        this.fileMap.clear();
        ((FileTableModel)this.fileTable.getModel()).fireTableDataChanged();
        this.showZipDialog(false);
        this.updateControls();
        this.setLocationRelativeTo(this.parent);
        this.setVisible(true);
        return !this.fileMap.isEmpty();
    }

    private boolean confirmSelection(File path, ZipFile zip) {
        if (zip.getEntry("pack.png") == null && zip.getEntry("pack.mcmeta") == null) {
            return true;
        }
        String message = String.format("The file %s\nappears to be a resource pack, not a mod.\nOnly mods should be added to MCPatcher this way.\n\nTo install a resource pack, copy it to the folder\n%s\nand select it in the Options, Resource Packs menu\nin the game.\n\nDo you want to add this file as a mod anyway?", path.getName(), MCPatcherUtils.getMinecraftPath("resourcepacks").getAbsolutePath());
        int result = JOptionPane.showConfirmDialog(this.parent, message, "Resource pack detected", 0);
        return result == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showZipDialog(boolean addMode) {
        if (this.file == null || !this.file.isFile()) {
            return;
        }
        this.hideZipDialog();
        try {
            String newPrefix;
            this.zipFile = new ZipFile(this.file);
            if (!this.confirmSelection(this.file, this.zipFile)) {
                MCPatcherUtils.close(this.zipFile);
                this.zipFile = null;
                return;
            }
            this.zipDialog = new ZipTreeDialog(this.zipFile);
            if (addMode || this.zipDialog.hasSubfolders()) {
                this.zipDialog.setLocationRelativeTo(this.parent);
                this.zipDialog.setVisible(true);
            }
            if ((newPrefix = this.zipDialog.getPrefix()) != null) {
                this.addFiles(newPrefix);
            }
        }
        catch (IOException e) {
            this.inputField.setText("");
            JOptionPane.showMessageDialog(null, "There was an error reading\n" + this.file.getPath() + "\n" + e.toString(), "Error reading zip file", 0);
            Logger.log(e);
        }
        finally {
            this.hideZipDialog();
            this.updateControls();
        }
    }

    private void hideZipDialog() {
        if (this.zipDialog != null) {
            this.zipDialog.setVisible(false);
            this.zipDialog.dispose();
            this.zipDialog = null;
        }
    }

    private void addFiles(String prefix) {
        boolean changed = false;
        for (ZipEntry zipEntry : Collections.list(this.zipFile.entries())) {
            String suffix;
            String name = zipEntry.getName();
            if (zipEntry.isDirectory() || !name.startsWith(prefix) || MinecraftJar.isGarbageFile(suffix = name.substring(prefix.length()))) continue;
            this.fileMap.put(suffix, name);
            changed = true;
        }
        if (changed) {
            ((DefaultTableModel)this.fileTable.getModel()).fireTableDataChanged();
        }
    }

    Mod getMod() {
        if (this.mod == null || this.mod.zipFile != this.zipFile) {
            MCPatcherUtils.close(this.zipFile);
            this.zipFile = null;
        }
        return this.mod;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        JTable jTable;
        JScrollPane jScrollPane;
        JButton jButton3;
        JTextField jTextField;
        JButton jButton4;
        JButton jButton5;
        JPanel jPanel;
        this.contentPane = jPanel = new JPanel();
        jPanel.setLayout(new GridLayoutManager(3, 1, new Insets(10, 10, 10, 10), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, true, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.buttonOK = jButton5 = new JButton();
        jButton5.setText("OK");
        jPanel3.add((Component)jButton5, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.buttonCancel = jButton4 = new JButton();
        jButton4.setText("Cancel");
        jPanel3.add((Component)jButton4, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 1, null, null, null));
        jPanel4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Select mod", 0, 0, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Mod");
        jLabel.setToolTipText("Path to zip file containing mod");
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.inputField = jTextField = new JTextField();
        jTextField.setEditable(false);
        ((Component)jTextField).setEnabled(true);
        jTextField.setColumns(35);
        jPanel4.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.browseButton = jButton3 = new JButton();
        jButton3.setToolTipText("Select mod zip file");
        jButton3.setText("Browse");
        jButton3.setMnemonic('B');
        jButton3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel5, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 6, null, null, null));
        jPanel5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Files to insert", 0, 0, null, null));
        this.fileTableScrollPane = jScrollPane = new JScrollPane();
        jPanel5.add((Component)jScrollPane, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 7, null, null, null));
        this.fileTable = jTable = new JTable();
        jTable.setPreferredScrollableViewportSize(new Dimension(450, 300));
        jScrollPane.setViewportView(jTable);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.addButton = jButton2 = new JButton();
        jButton2.setToolTipText("Select a set of files to add");
        jButton2.setText("");
        jButton2.setIcon(new ImageIcon(this.getClass().getResource("/resources/add.png")));
        jPanel6.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.removeButton = jButton = new JButton();
        jButton.setToolTipText("Remove the selected file");
        jButton.setText("");
        jButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/remove.png")));
        jPanel6.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel6.add((Component)spacer2, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel6.add((Component)spacer3, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.contentPane;
    }

    private class FileTableModel
    extends DefaultTableModel {
        FileTableModel() {
            super(new Object[]{"From", "To"}, 0);
        }

        @Override
        public int getRowCount() {
            return AddModDialog.this.fileMap.size();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        Map.Entry<String, String> getRow(int rowIndex) {
            ArrayList list = new ArrayList();
            list.addAll(AddModDialog.this.fileMap.entrySet());
            Collections.sort(list, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getValue().compareTo(o2.getValue());
                }
            });
            if (rowIndex >= 0 && rowIndex < list.size()) {
                return (Map.Entry)list.get(rowIndex);
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Map.Entry<String, String> entry = this.getRow(rowIndex);
            if (entry != null) {
                switch (columnIndex) {
                    case 0: {
                        return entry.getValue();
                    }
                    case 1: {
                        return entry.getKey();
                    }
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        }
    }
}

