/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.BytecodePatch;
import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassPatch;
import com.prupe.mcpatcher.ConstPoolUtils;
import com.prupe.mcpatcher.JavaRef;
import com.prupe.mcpatcher.MethodRef;
import java.io.IOException;
import java.util.Arrays;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.ConstPool;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.ExceptionTable;
import javassist.bytecode.MethodInfo;

public abstract class AddMethodPatch
extends ClassPatch {
    private final MethodRef methodRef;
    private final int accessFlags;
    private boolean allowDuplicate;
    protected int maxStackSize;
    protected int numLocals;
    protected ExceptionTable exceptionTable;

    public AddMethodPatch(ClassMod classMod, MethodRef methodRef) {
        this(classMod, methodRef, 1);
    }

    public AddMethodPatch(ClassMod classMod, MethodRef methodRef, int accessFlags) {
        super(classMod);
        this.methodRef = methodRef;
        this.accessFlags = accessFlags;
        this.allowDuplicate(true);
    }

    public AddMethodPatch(ClassMod classMod, String name) {
        this(classMod, name, 1);
    }

    public AddMethodPatch(ClassMod classMod, String name, int accessFlags) {
        this(classMod, new MethodRef(null, name, null), accessFlags);
    }

    public AddMethodPatch allowDuplicate(boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
        this.optional = allowDuplicate;
        return this;
    }

    @Override
    public final String getDescription() {
        return String.format("insert method %s %s", this.methodRef.getName(), this.getDescriptor());
    }

    protected void prePatch(ClassFile classFile) throws BadBytecode, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean apply(ClassFile classFile) throws BadBytecode, DuplicateMemberException, IOException {
        boolean patched;
        block11: {
            MethodInfo methodInfo;
            patched = false;
            this.prePatch(classFile);
            ConstPool constPool = classFile.getConstPool();
            MethodRef methodRef = (MethodRef)this.classMod.getClassMap().map((JavaRef)new MethodRef(this.classMod.getDeobfClass(), this.methodRef.getName(), this.getDescriptor()));
            this.classMod.methodInfo = methodInfo = new MethodInfo(constPool, methodRef.getName(), methodRef.getType());
            methodInfo.setAccessFlags(this.accessFlags);
            this.exceptionTable = new ExceptionTable(constPool);
            try {
                this.classMod.addToConstPool = true;
                this.classMod.resetLabels();
                byte[] code = this.generateMethod();
                if (code == null) break block11;
                this.classMod.resolveLabels(code, 0, 0);
                CodeAttribute codeAttribute = new CodeAttribute(constPool, this.maxStackSize, this.numLocals, code, this.exceptionTable);
                methodInfo.setCodeAttribute(codeAttribute);
                int argLocals = (this.accessFlags & 8) == 0 ? 0 : 1;
                int newMaxLocals = this.numLocals;
                for (String t : ConstPoolUtils.parseDescriptor(methodRef.getType())) {
                    if (t.equals("D") || t.equals("L")) {
                        argLocals += 2;
                        continue;
                    }
                    ++argLocals;
                }
                newMaxLocals = Math.max(argLocals, newMaxLocals);
                newMaxLocals = Math.max(BytecodePatch.computeMaxLocals(codeAttribute), newMaxLocals);
                if ((this.accessFlags & 8) == 0) {
                    newMaxLocals = Math.max(newMaxLocals, 1);
                }
                codeAttribute.setMaxLocals(newMaxLocals);
                int newStackSize = Math.max(codeAttribute.computeMaxStack(), this.maxStackSize);
                try {
                    classFile.addMethod(methodInfo);
                    patched = true;
                    this.recordPatch(String.format("stack size %d, local vars %d", newStackSize, newMaxLocals));
                }
                catch (DuplicateMemberException e) {
                    if (!this.allowDuplicate) {
                        boolean foundIdentical = false;
                        for (Object o : classFile.getMethods()) {
                            byte[] code2;
                            byte[] code1;
                            MethodInfo conflictMethod = (MethodInfo)o;
                            if (conflictMethod.getCodeAttribute() == null || !conflictMethod.getName().equals(methodInfo.getName()) || !conflictMethod.getDescriptor().equals(methodInfo.getDescriptor()) || conflictMethod.getAccessFlags() != methodInfo.getAccessFlags() || !Arrays.equals(code1 = methodInfo.getCodeAttribute().getCode(), code2 = conflictMethod.getCodeAttribute().getCode())) continue;
                            foundIdentical = true;
                            break;
                        }
                        if (!foundIdentical) {
                            throw e;
                        }
                    }
                }
            }
            finally {
                this.classMod.methodInfo = null;
                this.classMod.addToConstPool = false;
            }
        }
        return patched;
    }

    public String getDescriptor() {
        return this.methodRef.getType();
    }

    public abstract byte[] generateMethod();
}

