/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher;

import com.prupe.mcpatcher.ClassMod;
import com.prupe.mcpatcher.ClassPatch;
import com.prupe.mcpatcher.FieldRef;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.DuplicateMemberException;
import javassist.bytecode.FieldInfo;

public class AddFieldPatch
extends ClassPatch {
    private final FieldRef fieldRef;
    private final int accessFlags;
    private boolean allowDuplicate;

    public AddFieldPatch(ClassMod classMod, FieldRef fieldRef) {
        this(classMod, fieldRef, 1);
    }

    public AddFieldPatch(ClassMod classMod, FieldRef fieldRef, int accessFlags) {
        super(classMod);
        this.fieldRef = fieldRef;
        this.accessFlags = accessFlags;
        this.allowDuplicate(true);
    }

    public AddFieldPatch(ClassMod classMod, String name) {
        this(classMod, name, 1);
    }

    public AddFieldPatch(ClassMod classMod, String name, int accessFlags) {
        this(classMod, new FieldRef(null, name, null), accessFlags);
    }

    public AddFieldPatch allowDuplicate(boolean allowDuplicate) {
        this.allowDuplicate = allowDuplicate;
        this.optional = allowDuplicate;
        return this;
    }

    public String getDescriptor() {
        return this.fieldRef.getType();
    }

    @Override
    public String getDescription() {
        return String.format("insert field %s %s", this.fieldRef.getName(), this.getDescriptor());
    }

    @Override
    boolean apply(ClassFile classFile) throws BadBytecode, DuplicateMemberException {
        FieldInfo fieldInfo = new FieldInfo(classFile.getConstPool(), this.fieldRef.getName(), this.classMod.getClassMap().mapTypeString(this.getDescriptor()));
        fieldInfo.setAccessFlags(this.accessFlags);
        try {
            classFile.addField(fieldInfo);
            this.recordPatch();
        }
        catch (DuplicateMemberException e) {
            if (this.allowDuplicate) {
                for (Object o : classFile.getFields()) {
                    FieldInfo conflictField = (FieldInfo)o;
                    if (!conflictField.getName().equals(fieldInfo.getName())) continue;
                    if (!conflictField.getDescriptor().equals(fieldInfo.getDescriptor()) || conflictField.getAccessFlags() != fieldInfo.getAccessFlags()) break;
                    return false;
                }
                throw e;
            }
            throw e;
        }
        return true;
    }
}

