/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer.v1copy;

import com.sijobe.installer.v1copy.Util;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ThreadInstall
extends Thread {
    private List files;
    private File destination;
    private Method callback;
    private HashMap manifest;
    private File installBase;

    public ThreadInstall(List installFiles, File installBase, File destination, HashMap manifest) {
        this.files = installFiles;
        this.destination = destination;
        this.manifest = manifest;
        this.installBase = installBase;
    }

    public void setCallback(Method callback) {
        this.callback = callback;
    }

    private void signalDone(String err) {
        if (this.callback != null) {
            try {
                this.callback.invoke(null, err);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void run() {
        if (this.manifest == null) {
            this.manifest = Util.parseManifest(Util.getFile("manifest.xml", this.files));
            if (this.manifest == null) {
                this.signalDone("Couldn't find manifest file.");
                return;
            }
        }
        String[] filenames = new String[this.files.size()];
        int i = 0;
        i = 0;
        while (i < this.files.size()) {
            File file = (File)this.files.get(i);
            filenames[i++] = file.getAbsolutePath();
            ++i;
        }
        HashMap<String, Vector> destination = new HashMap<String, Vector>();
        Vector v = (Vector)((HashMap)this.manifest.get("Single Player Commands")).get("manifest");
        i = 0;
        while (i < v.size()) {
            HashMap t = (HashMap)v.get(i);
            String dest = new File(this.destination, (String)t.get("destination")).getAbsolutePath();
            String src = ((String)t.get("source")).replaceAll("\\.", "\\.").replaceAll("\\*", ".*");
            src = "\\Q" + this.installBase.getAbsolutePath().replaceAll("\\\\", "/") + "\\E" + "/" + src;
            Vector<File> source = new Vector<File>();
            int j = 0;
            while (j < this.files.size()) {
                File f = (File)this.files.get(j);
                if (f.getAbsolutePath().replaceAll("\\\\", "/").matches(src)) {
                    source.add(f);
                } else if (f.isDirectory() && (String.valueOf(f.getAbsolutePath().replaceAll("\\\\", "/")) + "/").matches(src)) {
                    source.add(f);
                }
                ++j;
            }
            if (!source.isEmpty()) {
                Vector o = (Vector)destination.get(dest);
                if (o == null) {
                    destination.put(dest, source);
                } else {
                    o.addAll(source);
                    destination.put(dest, o);
                }
            }
            ++i;
        }
        Iterator it = destination.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            File destpath = new File(key);
            if (!destpath.exists()) continue;
            File tmp = null;
            boolean recompress = false;
            if (destpath.isFile()) {
                tmp = Util.getTempDirectory();
                if (!Util.extractArchive(destpath, tmp)) continue;
                recompress = true;
            } else {
                if (!destpath.isDirectory()) continue;
                tmp = new File(key);
            }
            System.out.println(key);
            Vector d = (Vector)destination.get(key);
            int j = 0;
            while (j < d.size()) {
                File destfile = (File)d.elementAt(j);
                if (destfile.isFile()) {
                    Util.copyFile(destfile, new File(tmp, destfile.getName()));
                } else if (destfile.isDirectory()) {
                    Util.copyDirectory(destfile, new File(tmp, destfile.getName()));
                }
                ++j;
            }
            if (destpath.isFile() && destpath.getName().equalsIgnoreCase("minecraft.jar")) {
                Util.delete(new File(tmp, "META-INF/mojang_c.sf"));
                Util.delete(new File(tmp, "META-INF/mojang_c.dsa"));
            }
            if (recompress && !Util.compressFiles(tmp, destpath)) {
                this.signalDone("Unable to install to: " + destpath.getAbsolutePath() + "\n\nA common cause for this is that the file is already open elsewhere.");
                return;
            }
            if (!tmp.exists() || !destpath.isFile()) continue;
            Util.delete(tmp);
        }
        this.signalDone(null);
    }
}

