/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer.v1copy;

import com.sijobe.installer.v1copy.Util;
import java.io.File;
import java.lang.reflect.Method;

public class ThreadBackupMCJAR
extends Thread {
    private File mcdir;
    private Method callback;

    public ThreadBackupMCJAR(File mcdir) {
        this.mcdir = mcdir;
    }

    public void setCallback(Method callback) {
        this.callback = callback;
    }

    private void signalDone(String err) {
        if (this.callback != null) {
            try {
                this.callback.invoke(null, err);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void run() {
        if (this.mcdir == null || !this.mcdir.exists()) {
            this.signalDone("Couldn't discover Minecraft home directory.");
            return;
        }
        File mcjar = new File(this.mcdir, "bin/minecraft.jar");
        if (!mcjar.exists()) {
            this.signalDone("Couldn't find Minecraft.jar");
            return;
        }
        File destination = new File(this.mcdir, "backup/bin");
        try {
            destination.mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!destination.exists()) {
            this.signalDone("Couldn't create destination directory for backup.");
            return;
        }
        Util.copyFile(mcjar, new File(destination, "Minecraft.jar." + System.currentTimeMillis()));
        this.signalDone(null);
    }
}

