/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer.v1copy;

import com.sijobe.installer.v1copy.GUIMain;
import com.sijobe.installer.v1copy.ThreadBackupMCJAR;
import com.sijobe.installer.v1copy.ThreadBackupWorlds;
import com.sijobe.installer.v1copy.ThreadInstall;
import com.sijobe.installer.v1copy.Util;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class ActionHandler {
    public List files;
    public HashMap manifest;
    public static File base;
    private static GUIMain gui;
    static /* synthetic */ Class class$0;

    public ActionHandler(GUIMain gui) {
        this.initialiseData();
        ActionHandler.gui = gui;
    }

    public boolean initialiseData() {
        this.files = Util.getFilesExceptCurrent();
        File f = Util.getFile("manifest.xml", this.files);
        if (f == null) {
            return false;
        }
        this.manifest = Util.parseManifest(f);
        return true;
    }

    public void backupMCJAR(File dir) {
        base = dir;
        ThreadBackupMCJAR mcj = new ThreadBackupMCJAR(dir);
        ActionHandler.gui.btnBackupMCJAR.setEnabled(false);
        try {
            Class<?> clazz = this.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            mcj.setCallback(clazz.getDeclaredMethod("callbackBackupMCJAR", classArray));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mcj.start();
    }

    public static void callbackBackupMCJAR(String err) {
        ActionHandler.gui.btnBackupMCJAR.setEnabled(true);
        if (err != null) {
            gui.sendMessage(err, "Backup Failed");
            System.out.println("MCJAR BACKUP ERR: " + err);
        } else {
            gui.sendMessage("Your Minecraft.jar was successfully backed up to " + base + "/backup", "Backup Success");
            System.out.println("Success");
        }
    }

    public void backupWorlds(File dir) {
        ThreadBackupWorlds mcw = new ThreadBackupWorlds(dir);
        ActionHandler.gui.btnBackup.setEnabled(false);
        try {
            Class<?> clazz = this.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            mcw.setCallback(clazz.getDeclaredMethod("callbackBackupWorlds", classArray));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mcw.start();
    }

    public static void callbackBackupWorlds(String err) {
        ActionHandler.gui.btnBackup.setEnabled(true);
        if (err != null) {
            gui.sendError(err, "Backup Failed");
            System.out.println("MC WORLD ERR: " + err);
        } else {
            gui.sendMessage("Your worlds were successfully backed up to " + base + "/backup/saves", "Backup Success");
            System.out.println("Success");
        }
    }

    public void install(List installFiles, File installBase, File destination, HashMap manifest) {
        ThreadInstall mcw = new ThreadInstall(installFiles, installBase, destination, manifest);
        ActionHandler.gui.btnInstall.setEnabled(false);
        try {
            Class<?> clazz = this.getClass();
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            mcw.setCallback(clazz.getDeclaredMethod("callbackInstall", classArray));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        mcw.start();
    }

    public static void callbackInstall(String err) {
        ActionHandler.gui.btnInstall.setEnabled(true);
        if (err != null) {
            gui.sendError(err, "Install Failed");
            System.out.println("INSTALL FAILED ERR: " + err);
        } else {
            gui.sendMessage("Installation was successful", "Success");
        }
    }

    public void startMinecraft(File dir) {
        try {
            Vector<String> params = new Vector<String>();
            if (System.getProperty("os.name").toLowerCase().contains("win")) {
                params.add("javaw");
                params.add("-Xmx1024m");
                params.add("-classpath");
                params.add("Minecraft.jar;lwjgl.jar;lwjgl_util.jar;jinput.jar");
                params.add("-Djava.library.path=\"natives\"");
                params.add("net.minecraft.client.Minecraft");
            } else if (System.getProperty("os.name").toLowerCase().contains("mac")) {
                params.add("javaw");
                params.add("-Xmx1024m");
                params.add("-Xincgc");
                params.add("-classpath");
                params.add("Minecraft.jar:lwjgl.jar:lwjgl_util.jar:jinput.jar");
                params.add("-Dorg.lwjgl.librarypath=\"./natives\"");
                params.add("-Dnet.java.games.input.librarypath=\"$./natives\"");
                params.add("net.minecraft.client.Minecraft");
            } else {
                params.add("javaw");
                params.add("-Xmx1024m");
                params.add("-Xincgc");
                params.add("-classpath");
                params.add("Minecraft.jar:lwjgl.jar:lwjgl_util.jar:jinput.jar");
                params.add("-Dorg.lwjgl.librarypath=\"./natives\"");
                params.add("-Dnet.java.games.input.librarypath=\"./natives\"");
                params.add("net.minecraft.client.Minecraft");
            }
            if (params.size() > 0) {
                ProcessBuilder pb = new ProcessBuilder(params);
                pb.directory(new File(dir, "bin"));
                Process process = pb.start();
                if (process == null) {
                    throw new Exception("Process is null");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

