/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.UIManager;

public class Util {
    public static final int BUFFER = 4096;
    public static File INSTALLBASE;
    public static final String CLASSNAME = "Util.class";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public static File getMinecraftDir() {
        File dir = null;
        String sys = System.getProperty("user.home", ".");
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("win")) {
            String data = System.getenv("APPDATA");
            dir = data != null ? new File(data, ".minecraft/") : new File(sys, ".minecraft/");
        } else if (os.contains("mac")) {
            dir = new File(sys, "Library/Application Support/minecraft");
        } else if (os.contains("solaris")) {
            dir = new File(sys, ".minecraft/");
        } else {
            dir = new File(sys, "minecraft/");
            if (!dir.exists() || !dir.isDirectory()) {
                dir = new File(sys, ".minecraft/");
            }
        }
        if (dir == null || !dir.exists() || !dir.isDirectory()) {
            return null;
        }
        return dir;
    }

    public static List getFilesExceptCurrent() {
        File base;
        block29: {
            Class<?> clazz;
            Class<?> clazz2 = class$0;
            if (clazz2 == null) {
                try {
                    clazz2 = class$0 = Class.forName("com.sijobe.installer.Util");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String test = clazz2.getResource(CLASSNAME).toString();
            base = null;
            if (test.startsWith("jar")) {
                String jarfile = test.replaceAll("jar:", "").split("!")[0];
                try {
                    File extract = Util.getTempDirectory();
                    if (Util.extractArchive(new File(new URL(jarfile).toURI()), extract)) {
                        base = extract;
                        break block29;
                    }
                    return null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            Class<?> clazz3 = class$0;
            if (clazz3 == null) {
                try {
                    clazz3 = class$0 = Class.forName("com.sijobe.installer.Util");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String classLocation = String.valueOf(clazz3.getName().replace('.', '/')) + ".class";
            Class<?> clazz4 = class$0;
            if (clazz4 == null) {
                try {
                    clazz4 = class$0 = Class.forName("com.sijobe.installer.Util");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            String packagename = clazz4.getPackage().getName();
            int parents = 0;
            try {
                Class<?> clazz5 = class$0;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$0 = Class.forName("com.sijobe.installer.Util");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                packagename = clazz5.getPackage().getName();
                parents = packagename.split("\\.").length;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if ((clazz = class$0) == null) {
                try {
                    clazz = class$0 = Class.forName("com.sijobe.installer.Util");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            URLClassLoader loader = (URLClassLoader)clazz.getClassLoader();
            URL u = loader.getResource(classLocation);
            File f = new File(u.getFile()).getParentFile();
            try {
                if (f == null || !f.exists()) {
                    f = new File(u.toURI()).getParentFile();
                }
            }
            catch (Exception e) {
                return null;
            }
            int i = 0;
            while (i < parents) {
                f = f.getParentFile();
                ++i;
            }
            if (f == null || !f.exists()) {
                return null;
            }
            base = f;
        }
        if (base == null || !base.isDirectory()) {
            return null;
        }
        List temp = Util.getFiles(base);
        Iterator i = temp.iterator();
        while (i.hasNext()) {
            File tempfile = (File)i.next();
            if (!tempfile.getName().equalsIgnoreCase(CLASSNAME)) continue;
            temp.remove(tempfile);
            break;
        }
        INSTALLBASE = base;
        return temp;
    }

    public static List getFiles(File directory) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        Vector<File> thelist = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            thelist.add(file);
            ++i;
        }
        return thelist;
    }

    public static List getAllFiles(File directory) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return null;
        }
        File[] files = directory.listFiles();
        Vector<File> thelist = new Vector<File>();
        int i = 0;
        while (i < files.length) {
            File file = files[i];
            if (file.isDirectory()) {
                thelist.add(file);
                thelist.addAll(Util.getAllFiles(file));
            } else {
                thelist.add(file);
            }
            ++i;
        }
        return thelist;
    }

    public static File getTempDirectory() {
        File temp;
        try {
            temp = File.createTempFile("mcmodinst", String.valueOf(System.currentTimeMillis()));
            if (!temp.delete()) {
                throw new IOException("Temp file not deleted: " + temp.getAbsolutePath());
            }
            if (!temp.mkdir()) {
                throw new IOException("Temp directory not created: " + temp.getAbsolutePath());
            }
        }
        catch (Exception e) {
            temp = null;
            e.printStackTrace();
        }
        return temp;
    }

    public static boolean extractArchive(File archive, File destination) {
        if (archive == null || destination == null) {
            return false;
        }
        System.out.println("Extracting " + archive.getName());
        try {
            destination.mkdirs();
        }
        catch (Exception e) {
            return false;
        }
        ZipFile zf = null;
        try {
            zf = new ZipFile(archive);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        try {
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                int currentByte;
                ZipEntry ze = e.nextElement();
                File dest = new File(destination, ze.getName());
                dest.getParentFile().mkdirs();
                if (ze.isDirectory()) continue;
                BufferedInputStream is = new BufferedInputStream(zf.getInputStream(ze));
                byte[] data = new byte[4096];
                FileOutputStream fos = new FileOutputStream(dest);
                BufferedOutputStream des = new BufferedOutputStream(fos, 4096);
                while ((currentByte = is.read(data, 0, 4096)) != -1) {
                    des.write(data, 0, currentByte);
                }
                des.flush();
                des.close();
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean compressFiles(File source, File destination) {
        if (source == null || destination == null) {
            return false;
        }
        System.out.println("Compressing " + destination.getName());
        try {
            URI base = source.toURI();
            BufferedInputStream origin = null;
            FileOutputStream dest = new FileOutputStream(destination);
            ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(dest));
            byte[] data = new byte[4096];
            Vector<File> file = null;
            if (source.isDirectory()) {
                file = Util.getAllFiles(source);
            } else if (source.isFile()) {
                file = new Vector<File>();
                file.add(source);
            }
            Iterator i = file.iterator();
            while (i.hasNext()) {
                int count;
                ZipEntry entry;
                File next = (File)i.next();
                if (next.isDirectory()) {
                    entry = new ZipEntry(base.relativize(next.toURI()).getPath());
                    out.putNextEntry(entry);
                    continue;
                }
                origin = new BufferedInputStream(new FileInputStream(next), 4096);
                entry = new ZipEntry(base.relativize(next.toURI()).getPath());
                out.putNextEntry(entry);
                while ((count = origin.read(data, 0, 4096)) != -1) {
                    out.write(data, 0, count);
                }
                origin.close();
            }
            out.close();
        }
        catch (Exception e) {
            System.out.println("ERROR: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean copyDirectory(File from, File to) {
        System.out.println("Copying directory " + from.getName());
        if (from == null || to == null || !from.isDirectory()) {
            System.out.println("ERROR: Specified file is not a directory.");
            return false;
        }
        if (!to.exists()) {
            to.mkdirs();
        }
        if (!to.isDirectory()) {
            System.out.println("ERROR: Destination is not a directory.");
            return false;
        }
        try {
            File[] list = from.listFiles();
            int i = 0;
            while (i < list.length) {
                if (list[i].isDirectory()) {
                    Util.copyDirectory(list[i], new File(to, list[i].getName()));
                } else if (list[i].isFile()) {
                    Util.copyFile(list[i], new File(to, list[i].getName()));
                }
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("ERROR: " + e.getMessage());
            return false;
        }
        return true;
    }

    public static boolean copyFile(File sourceFile, File destFile) {
        System.out.println("Copying " + sourceFile.getName());
        if (!destFile.exists()) {
            try {
                destFile.getParentFile().mkdirs();
                destFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
                System.out.println("ERROR (1): Could not copy " + destFile.getAbsolutePath());
                return false;
            }
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            try {
                source = new FileInputStream(sourceFile).getChannel();
                destination = new FileOutputStream(destFile).getChannel();
                ((FileChannel)destination).transferFrom(source, 0L, source.size());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("ERROR (2): Could not copy " + destFile.getAbsolutePath());
                try {
                    if (source != null) {
                        source.close();
                    }
                    if (destination != null) {
                        destination.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (source != null) {
                    source.close();
                }
                if (destination != null) {
                    destination.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    public static void delete(File file) {
        if (file == null || !file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
            return;
        }
        File[] children = file.listFiles();
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            if (child.isFile()) {
                child.delete();
            } else {
                Util.delete(child);
            }
            ++i;
        }
        file.delete();
    }

    public static String readFile(File filename) {
        String content;
        block14: {
            if (filename == null) {
                return "";
            }
            content = "";
            BufferedReader in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(filename));
                    String line = null;
                    while ((line = in.readLine()) != null) {
                        content = String.valueOf(content) + line + "\n";
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    if (in == null) break block14;
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return content;
    }

    public static BufferedImage scale(BufferedImage src, int w, int h) {
        int type = 1;
        BufferedImage dst = new BufferedImage(w, h, type);
        Graphics2D g2 = dst.createGraphics();
        g2.setBackground(UIManager.getColor("Panel.background"));
        g2.clearRect(0, 0, w, h);
        double xScale = (double)w / (double)src.getWidth();
        double yScale = (double)h / (double)src.getHeight();
        double scale = Math.min(xScale, yScale);
        int width = (int)(scale * (double)src.getWidth());
        int height = (int)(scale * (double)src.getHeight());
        int x = (w - width) / 2;
        int y = (h - height) / 2;
        g2.drawImage(src, x, y, width, height, null);
        g2.dispose();
        return dst;
    }

    public static File getFile(String name, List files) {
        int i = 0;
        while (i < files.size()) {
            File f = (File)files.get(i);
            System.out.println("DEBUG: " + f.getName());
            if (f.getName().equalsIgnoreCase(name)) {
                return f;
            }
            ++i;
        }
        return null;
    }

    public static boolean addToClasspath(File file) {
        return Util.addToClasspath(file, (URLClassLoader)ClassLoader.getSystemClassLoader());
    }

    public static boolean addToClasspath(File file, URLClassLoader loader) {
        if (!file.exists()) {
            return false;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.net.URLClassLoader");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> sysclass = clazz;
        try {
            Class[] classArray = new Class[1];
            Class<?> clazz2 = class$2;
            if (clazz2 == null) {
                try {
                    clazz2 = class$2 = Class.forName("java.net.URL");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz2;
            Method method = sysclass.getDeclaredMethod("addURL", classArray);
            method.setAccessible(true);
            method.invoke((Object)loader, file.toURI().toURL());
        }
        catch (Throwable t) {
            t.printStackTrace();
            return false;
        }
        return true;
    }

    public static String getMinecraftVersion(String mcdir) {
        File mcjar = new File(mcdir, "bin/minecraft.jar");
        File lwjgl = new File(mcdir, "bin/lwjgl.jar");
        if (!mcjar.exists() || !lwjgl.exists()) {
            return null;
        }
        URLClassLoader loader = null;
        Class<?> minecraft = null;
        try {
            loader = new URLClassLoader(new URL[]{mcjar.toURI().toURL(), lwjgl.toURI().toURL()}, null);
            int i = 0;
            while (i < loader.getURLs().length) {
                System.out.println(loader.getURLs().toString());
                ++i;
            }
            minecraft = Class.forName("net.minecraft.client.Minecraft", false, loader);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
        try {
            Method[] methods = minecraft.getMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?> clazz = methods[i].getReturnType();
                Class<?> clazz2 = class$3;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz == clazz2 && methods[i].getParameterTypes().length == 0 && Modifier.isStatic(methods[i].getModifiers())) {
                    return (String)methods[i].invoke(null, null);
                }
                ++i;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        return null;
    }
}

