/*
 * Decompiled with CFR 0.152.
 */
package com.sijobe.installer;

import com.sijobe.installer.ManifestFile;
import com.sijobe.installer.ManifestHandler;
import com.sijobe.installer.ManifestScript;
import com.sijobe.installer.Util;
import java.io.File;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ThreadInstall
extends Thread {
    private List files;
    private File destination;
    private Method callback;
    private ManifestHandler manifest;
    private File installBase;
    private String project;
    static /* synthetic */ Class class$0;

    public ThreadInstall(String project, List installFiles, File installBase, File destination, ManifestHandler manifest) {
        this.files = installFiles;
        this.destination = destination;
        this.manifest = manifest;
        this.installBase = installBase;
        this.project = project;
    }

    public void setCallback(Method callback) {
        this.callback = callback;
    }

    private void signalDone(String err) {
        if (this.callback != null) {
            try {
                this.callback.invoke(null, err);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String install(String project, List files, File installBase, File destination, ManifestHandler manifest) {
        if (manifest == null && (manifest = new ManifestHandler(Util.getFile("manifest.xml", files))).getProjectNames().length == 0) {
            return "Couldn't find manifest file.";
        }
        String[] filenames = new String[files.size()];
        int i = 0;
        i = 0;
        while (i < files.size()) {
            File file = (File)files.get(i);
            filenames[i++] = file.getAbsolutePath();
            ++i;
        }
        HashMap<String, Vector> destinationh = new HashMap<String, Vector>();
        List v = manifest.getProjectManifest(project);
        i = 0;
        while (i < v.size()) {
            Object temp = v.get(i);
            ManifestFile t = null;
            if (!(temp instanceof ManifestFile)) {
                if (temp instanceof ManifestScript && !ThreadInstall.executeScript((ManifestScript)temp, files, installBase, destination)) {
                    System.out.println("ERROR " + ((ManifestScript)temp).getSource() + " failed to run.");
                }
            } else {
                t = (ManifestFile)temp;
                String dest = new File(destination, t.getDestination()).getAbsolutePath();
                String src = t.getSource().replaceAll("\\.", "\\.").replaceAll("\\*", ".*");
                src = "\\Q" + installBase.getAbsolutePath().replaceAll("\\\\", "/") + "\\E" + "/" + src;
                Vector<File> source = new Vector<File>();
                System.out.println("DEBUG " + dest + " " + src);
                int j = 0;
                while (j < files.size()) {
                    File f = (File)files.get(j);
                    if (f.getAbsolutePath().replaceAll("\\\\", "/").matches(src)) {
                        source.add(f);
                    } else if (f.isDirectory() && (String.valueOf(f.getAbsolutePath().replaceAll("\\\\", "/")) + "/").matches(src)) {
                        source.add(f);
                    }
                    ++j;
                }
                if (!source.isEmpty()) {
                    Vector o = (Vector)destinationh.get(dest);
                    if (o == null) {
                        destinationh.put(dest, source);
                    } else {
                        o.addAll(source);
                        destinationh.put(dest, o);
                    }
                }
            }
            ++i;
        }
        Iterator it = destinationh.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            System.out.println("DEBUG " + key);
            File destpath = new File(key);
            if (!destpath.exists()) continue;
            File tmp = null;
            boolean recompress = false;
            if (destpath.isFile()) {
                tmp = Util.getTempDirectory();
                if (!Util.extractArchive(destpath, tmp)) {
                    System.out.println("ERROR - Failed installing: " + destpath.getAbsolutePath() + " > " + tmp.getAbsolutePath());
                    continue;
                }
                recompress = true;
            } else {
                if (!destpath.isDirectory()) continue;
                tmp = new File(key);
            }
            Vector d = (Vector)destinationh.get(key);
            int j = 0;
            while (j < d.size()) {
                File destfile = (File)d.elementAt(j);
                if (destfile.isFile()) {
                    Util.copyFile(destfile, new File(tmp, destfile.getName()));
                } else if (destfile.isDirectory()) {
                    Util.copyDirectory(destfile, new File(tmp, destfile.getName()));
                }
                ++j;
            }
            if (destpath.isFile() && destpath.getName().equalsIgnoreCase("minecraft.jar")) {
                Util.delete(new File(tmp, "META-INF/CODESIGN.SF"));
                Util.delete(new File(tmp, "META-INF/CODESIGN.rsa"));
            }
            if (recompress && !Util.compressFiles(tmp, destpath)) {
                return "Unable to install to: " + destpath.getAbsolutePath() + "\n\nA common cause for this is that the file is already open elsewhere.";
            }
            if (!tmp.exists() || !destpath.isFile()) continue;
            Util.delete(tmp);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean executeScript(ManifestScript script, List files, File source, File destination) {
        if (script.getSource() == null) return false;
        if (script.getType() == null) {
            return false;
        }
        File scriptfile = Util.getFile(script.getSource(), files);
        if (scriptfile == null) return false;
        if (!scriptfile.exists()) {
            return false;
        }
        try {
            if (script.getDependencies() != null) {
                int i = 0;
                while (i < script.getDependencies().length) {
                    File dependency = Util.getFile(script.getDependencies()[i], files);
                    if (!Util.addToClasspath(dependency)) {
                        System.out.println("Unable to add specified dependency " + dependency.getName());
                        return false;
                    }
                    ++i;
                }
            }
            if (!script.getType().equalsIgnoreCase("java")) return true;
            if (!Util.addToClasspath(scriptfile)) {
                return false;
            }
            Class<?> loader = Class.forName(script.getClassname());
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("[Ljava.lang.String;");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            classArray[0] = clazz;
            Method main = loader.getMethod("main", classArray);
            main.setAccessible(true);
            if (!main.isAccessible()) {
                return false;
            }
            main.invoke(null, new Object[]{new String[]{script.getClassname(), source.getAbsolutePath(), destination.getAbsolutePath()}});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void run() {
        this.signalDone(ThreadInstall.install(this.project, this.files, this.installBase, this.destination, this.manifest));
    }
}

